/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.jboss.helper.JBossHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def isWindows = apTool.isWindows

def jbossPath = props['jbosspath']
def appName = props['appName']
def keepContent = props['keepContent'] != null ? props['keepContent'].toBoolean() : false
def keepAttr = this.args[2].toBoolean()
def allServerGroups = props['allServerGroups'] != null ? props['allServerGroups'].toBoolean() : false
def serverGroups = props['serverGroups'] != null ? props['serverGroups'] : ""
def cli = isWindows ? "jboss-cli.bat" : "jboss-cli.sh"
def controller = props['controller'] != null ? props['controller'] : ""
def username = props['username'] != null ? props['username'] : ""
def password = props['password'] != null ? props['password'] : ""

def pathFile = new File(jbossPath)
def cliFile = new File(pathFile, cli)

if (!cliFile.isFile()) {
    executable = isWindows ? "jboss-admin.bat" : "jboss-admin.sh"
    cliFile = new File(pathFile, executable)
    
    if (!cliFile.isFile()) {
        throw new Exception("Could not find JBoss executable")
    }
}

def cmdArgs = [cliFile.absolutePath]

if (controller?.trim()?.size() > 0) {
    cmdArgs << "--controller=${controller}"
}

if (username) {
    cmdArgs << "--user=${username}"
}

if (password) {
    cmdArgs << "--password=${password}"
}

def helper = new JBossHelper(cmdArgs)

def scriptData = helper.createTempFile()

scriptData.withWriter { out ->
    out << "connect\n"
    out << "undeploy " + appName

    if (keepContent || keepAttr) {
        out << " --keep-content"
    }


    if (allServerGroups) {
        out << " --all-relevant-server-groups"
    }
    else if (serverGroups?.trim()?.size() > 0) {
        out << " --server-groups=${serverGroups}"
    }
}

cmdArgs << "--file=${scriptData.absolutePath}"

if (keepAttr) {
    helper.runDisableCommand("Disabling application")
}
else {
    helper.runUndeployCommand("Undeploying Application from JBoss")
}
System.exit(0)
