/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import com.urbancode.winapi.Handle;
import com.urbancode.winapi.RefInt;
import com.urbancode.winapi.WinApi;
import com.urbancode.winapi.WindowsException;
import com.urbancode.winapi.WindowsIOException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class HandleInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger(HandleInputStream.class);
    private final Handle handle;
    private final boolean closeHandle;

    public HandleInputStream(Handle handle, boolean closeHandle) {
        if (handle == null) {
            throw new NullPointerException("handle");
        }
        if (!handle.isOpen()) {
            throw new IllegalArgumentException("handle is not open");
        }
        this.handle = handle;
        this.closeHandle = closeHandle;
    }

    public synchronized void close() throws IOException {
        if (this.closeHandle) {
            try {
                this.handle.close();
            }
            catch (WindowsException e) {
                throw new WindowsIOException(e);
            }
        }
    }

    public int read() throws IOException {
        int result = -1;
        byte[] buffer = new byte[1];
        result = this.read0(buffer, 0, 1);
        if (result != -1) {
            result = buffer[0] & 0xFF;
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("b");
        }
        return this.read0(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off < 0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len < 0");
        }
        if (len > b.length - off) {
            throw new IndexOutOfBoundsException("len + off > b.length");
        }
        int result = -1;
        if (len > 0) {
            result = this.read0(b, off, len);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0(byte[] b, int off, int len) throws IOException {
        int result;
        try {
            RefInt read = new RefInt();
            Thread thread = Thread.currentThread();
            String oldThreadName = null;
            if (log.isTraceEnabled()) {
                oldThreadName = thread.getName();
                thread.setName(oldThreadName + ": reading on handle " + this.handle);
                log.trace((Object)("Reading on handle " + this.handle));
            }
            try {
                HandleInputStream handleInputStream = this;
                synchronized (handleInputStream) {
                    WinApi.ReadFile(this.handle, b, off, len, read, null);
                }
            }
            finally {
                if (oldThreadName != null) {
                    thread.setName(oldThreadName);
                }
            }
            result = read.value;
            result = result == 0 ? -1 : result;
        }
        catch (WindowsException e) {
            if (e.getCode() == 109) {
                result = -1;
            }
            throw new WindowsIOException(e);
        }
        return result;
    }
}

