/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell;

import com.urbancode.commons.util.ExceptionSupport;
import com.urbancode.commons.util.environment.Environment;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.process.NativeProcess;
import com.urbancode.process.jdk7.ProcessBuilder;
import com.urbancode.process.jdk7.ProcessBuilderUtil;
import com.urbancode.shell.ApacheCommandline;
import com.urbancode.shell.CommandLine;
import com.urbancode.shell.EnvVar;
import com.urbancode.shell.Os;
import com.urbancode.shell.ShellException;
import com.urbancode.shell.impersonation.GetEnvCommand;
import com.urbancode.shell.impersonation.ImpersonateCommand;
import com.urbancode.shell.impersonation.ImpersonationCommandFactory;
import com.urbancode.shell.impersonation.ImpersonationToken;
import com.urbancode.shell.impersonation.unix.UnixImpersonationCommandFactory;
import com.urbancode.shell.impersonation.windows.WindowsImpersonateCommandFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shell {
    private static final Logger log = Logger.getLogger((String)Shell.class.getName());
    private static final ExceptionSupport exceptions = new ExceptionSupport();
    protected final ImpersonationCommandFactory impersonationFactory = Shell.newImpersonationCommandFactory();
    protected CommandLine commandLine = null;
    protected File workDir = null;
    protected Set<EnvVar> envVarSet = Shell.newEnvironmentSet();
    protected Set<EnvVar> baseEnvironment;
    protected Process process = null;
    protected int exitValue = Integer.MIN_VALUE;
    protected boolean processKilled = false;
    protected boolean daemon = false;
    protected File outputFile = null;
    protected ImpersonationToken impersonationToken;
    protected Unix unix = new Unix();

    public static EnvVar[] getEnvironment() throws ShellException, IOException {
        Map environment = Environment.getGlobalInstance().toImmutableMap();
        ArrayList<EnvVar> list = new ArrayList<EnvVar>();
        for (Map.Entry entry : environment.entrySet()) {
            list.add(new EnvVar((String)entry.getKey(), (String)entry.getValue()));
        }
        return list.toArray(new EnvVar[list.size()]);
    }

    public static boolean isCaseSensitive() {
        return !Os.isFamily("windows") && !Os.isFamily("vms");
    }

    public static String getEnvVarValue(String name) throws ShellException, IOException {
        return Environment.getGlobalInstance().get(name);
    }

    protected static String[] toStringArray(EnvVar[] envVarArray) {
        String[] result = new String[envVarArray.length];
        for (int i = 0; i < envVarArray.length; ++i) {
            result[i] = envVarArray[i].getName() + "=" + envVarArray[i].getValue();
        }
        return result;
    }

    public static Map<String, String> newEnvironmentMap() {
        AbstractMap result = Shell.isCaseSensitive() ? new HashMap() : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        return result;
    }

    public static Map<String, String> newEnvironmentMap(Map<String, String> m) {
        AbstractMap result;
        if (Shell.isCaseSensitive()) {
            result = new HashMap<String, String>(m);
        } else {
            result = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            result.putAll(m);
        }
        return result;
    }

    public static Set<EnvVar> newEnvironmentSet() {
        AbstractSet result = Shell.isCaseSensitive() ? new HashSet() : new TreeSet<EnvVar>(EnvVar.CASE_INSENSITIVE_ORDER);
        return result;
    }

    public static Set<EnvVar> newEnvironmentSet(Collection<? extends EnvVar> c) {
        HashSet<EnvVar> result;
        if (Shell.isCaseSensitive()) {
            result = new HashSet<EnvVar>(c);
        } else {
            result = new TreeSet<EnvVar>(EnvVar.CASE_INSENSITIVE_ORDER);
            result.addAll(c);
        }
        return result;
    }

    private static ImpersonationCommandFactory newImpersonationCommandFactory() {
        if (Os.isFamily("windows")) {
            return new WindowsImpersonateCommandFactory();
        }
        return new UnixImpersonationCommandFactory();
    }

    public Shell(String commandStr) {
        this.commandLine = new CommandLine(new ApacheCommandline(commandStr).getCommandline());
    }

    public Shell(String[] commandArray) {
        this.commandLine = new CommandLine(commandArray);
    }

    public Shell(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    public Shell(List<String> command) {
        this.commandLine = new CommandLine(command);
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setImpersonationToken(ImpersonationToken impersonationToken) {
        this.impersonationToken = impersonationToken;
        this.baseEnvironment = null;
    }

    public void setWorkingDirectoryName(String wdName) {
        if (wdName == null) {
            throw new IllegalArgumentException("Specified work dir is null");
        }
        if (wdName.trim().length() == 0) {
            wdName = ".";
        }
        this.setWorkingDirectory(new File(wdName));
    }

    public String getWorkingDirectoryName() {
        String result = null;
        if (this.workDir != null) {
            result = this.workDir.getAbsolutePath();
        }
        return result;
    }

    public void setWorkingDirectory(File wd) {
        if (!wd.exists()) {
            throw new IllegalArgumentException("Specified work dir does not exist: " + wd.getAbsolutePath());
        }
        if (!wd.isDirectory()) {
            throw new IllegalArgumentException("Specified work dir is not a directory: " + wd.getAbsolutePath());
        }
        this.workDir = wd;
    }

    public File getWorkingDirectory() {
        return this.workDir;
    }

    public void addEnvironmentVariable(String name, String value) {
        this.addEnvironmentVariable(new EnvVar(name, value));
    }

    public void addEnvironmentVariable(String name, String value, boolean secure) {
        this.addEnvironmentVariable(new EnvVar(name, value, secure));
    }

    public void addEnvironmentVariable(EnvVar var) {
        this.envVarSet.remove(var);
        this.envVarSet.add(var);
    }

    public EnvVar[] getEnvironmentVariableArray() {
        EnvVar[] result = new EnvVar[this.envVarSet.size()];
        this.envVarSet.toArray(result);
        return result;
    }

    public Process getProcess() {
        return this.process;
    }

    public OutputStream getOutputStream() {
        OutputStream result = null;
        if (this.process != null) {
            result = this.process.getOutputStream();
        }
        return result;
    }

    public InputStream getErrorStream() {
        InputStream result = null;
        if (this.process != null) {
            result = this.process.getErrorStream();
        }
        return result;
    }

    public InputStream getInputStream() {
        InputStream result = null;
        if (this.process != null) {
            result = this.process.getInputStream();
        }
        return result;
    }

    public int getExitValue() {
        block3: {
            if (this.exitValue == Integer.MIN_VALUE && this.process != null) {
                try {
                    this.exitValue = this.process.exitValue();
                }
                catch (IllegalThreadStateException itse) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Attempted to get exit code for running process " + this.process), (Throwable)itse);
                }
            }
        }
        return this.exitValue;
    }

    public EnvVar[] getPatchedEnvVarArray() throws ShellException, IOException {
        Set<EnvVar> variables = Shell.newEnvironmentSet(this.getBaseEnvironment());
        EnvVar[] localVarArray = this.getEnvironmentVariableArray();
        boolean caseSensitive = Shell.isCaseSensitive();
        for (EnvVar newVar : localVarArray) {
            boolean found = false;
            for (EnvVar var : variables) {
                found = caseSensitive ? var.getName().equals(newVar.getName()) : var.getName().equalsIgnoreCase(newVar.getName());
                if (!found) continue;
                var.setName(newVar.getName());
                var.setValue(newVar.getValue());
                var.setSecure(newVar.isSecure());
                break;
            }
            if (found) continue;
            variables.add(newVar);
        }
        return variables.toArray(new EnvVar[variables.size()]);
    }

    public synchronized void execute() throws ShellException {
        try {
            if (this.impersonationToken == null) {
                this.executeAsSelf();
            } else {
                this.executeAsImpersonator();
            }
        }
        catch (ShellException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable rootCause = exceptions.getRootCause((Throwable)e);
            if (log.isDebugEnabled()) {
                log.error((Object)e.toString(), (Throwable)e);
            } else if (rootCause != e) {
                log.error((Object)(e + "(caused by " + rootCause + ")"));
            } else {
                log.error((Object)e.toString());
            }
            StringBuilder message = new StringBuilder("Error invoking process: ");
            String rootMessage = rootCause.getMessage();
            if (rootMessage != null) {
                if (rootMessage.contains("error=2")) {
                    message.append("The executable does not exist or is not on the PATH");
                } else if (rootMessage.contains("error=193")) {
                    message.append("The executable is not valid");
                } else {
                    message.append(rootMessage);
                }
            } else {
                message.append("Unknown cause");
            }
            message.append(": ").append(this.commandLine);
            throw new ShellException(message.toString(), e);
        }
    }

    private Set<EnvVar> getBaseEnvironment() throws ShellException, IOException {
        if (this.baseEnvironment == null) {
            Set<EnvVar> set = Shell.newEnvironmentSet();
            if (this.impersonationToken == null) {
                set.addAll(Arrays.asList(Shell.getEnvironment()));
            } else {
                GetEnvCommand getEnv = this.impersonationFactory.newGetEnvCommand(this.impersonationToken);
                Map<String, String> map = getEnv.execute();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    set.add(new EnvVar(entry.getKey(), entry.getValue()));
                }
            }
            this.baseEnvironment = Collections.unmodifiableSet(set);
        }
        return this.baseEnvironment;
    }

    private Map<String, String> getPatchedEnvMap() throws ShellException, IOException {
        Map<String, String> result = Shell.newEnvironmentMap();
        for (EnvVar v : this.getPatchedEnvVarArray()) {
            result.put(v.getName(), v.getValue());
        }
        return result;
    }

    private void executeAsSelf() throws ShellException, IOException {
        ProcessBuilder builder = new ProcessBuilder(this.commandLine.toStringArray());
        builder.directory(this.workDir);
        Map env = builder.environment();
        env.clear();
        env.putAll(this.getPatchedEnvMap());
        if (this.daemon) {
            ProcessBuilderUtil util = ProcessBuilderUtil.newInstance();
            File nullFile = util.nullDeviceFile();
            if (this.outputFile == null) {
                builder.redirectOutput(nullFile);
            } else {
                builder.redirectOutput(this.outputFile);
            }
            builder.redirectErrorStream(true);
            builder.redirectInput(nullFile);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting a daemon process");
            }
            builder.start();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting a non-daemon process");
            }
            if (this.outputFile != null) {
                builder.redirectOutput(this.outputFile);
                builder.redirectErrorStream(true);
            }
            this.process = builder.start();
        }
    }

    private void executeAsImpersonator() throws ShellException, IOException {
        ProcessBuilder.Redirect inputRedirect = ProcessBuilder.Redirect.PIPE;
        ProcessBuilder.Redirect outputRedirect = ProcessBuilder.Redirect.PIPE;
        ProcessBuilder.Redirect errorRedirect = ProcessBuilder.Redirect.PIPE;
        if (this.daemon) {
            ProcessBuilderUtil util = ProcessBuilderUtil.newInstance();
            File nullFile = util.nullDeviceFile();
            outputRedirect = this.outputFile == null ? ProcessBuilder.Redirect.to((File)nullFile) : ProcessBuilder.Redirect.to((File)this.outputFile);
            errorRedirect = null;
            inputRedirect = ProcessBuilder.Redirect.from((File)nullFile);
        }
        ImpersonateCommand impersonate = this.impersonationFactory.newImpersonateCommand(this.impersonationToken, this.commandLine.toList(), this.getWorkingDirectoryName(), this.getPatchedEnvMap(), inputRedirect, outputRedirect, errorRedirect);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing shell as " + this.impersonationToken.getUser()));
        }
        if (this.daemon) {
            impersonate.execute().releaseResources();
        } else {
            this.process = impersonate.execute();
        }
    }

    public void waitForCompletion() throws ShellException {
        if (this.process != null) {
            try {
                int exitCode = this.process.waitFor();
                if (log.isDebugEnabled()) {
                    String command = this.commandLine.getArgArray()[0].toString();
                    log.debug((Object)("Command " + command + " completed with exit code " + exitCode));
                }
                if (this.process instanceof NativeProcess) {
                    ((NativeProcess)this.process).releaseResources();
                }
            }
            catch (InterruptedException e) {
                if (!this.processKilled) {
                    throw new ShellException(e);
                }
            }
            catch (Exception e) {
                throw new ShellException(e);
            }
        }
    }

    public boolean isCompleted() {
        int value = this.getExitValue();
        return value != Integer.MIN_VALUE;
    }

    public boolean isProcessKilled() {
        return this.processKilled;
    }

    public void killProcess() throws ShellException {
        this.processKilled = true;
        if (this.process != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Killing process - " + this.process));
                }
                if (this.process instanceof NativeProcess) {
                    NativeProcess nativeProcess = (NativeProcess)this.process;
                    nativeProcess.destroyTree();
                    nativeProcess.releaseResources();
                } else {
                    this.process.destroy();
                }
            }
            catch (Exception e) {
                throw new ShellException(e);
            }
        }
    }
}

