/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.urbancode.air.plugin.jboss.helper

class StreamPrinter extends Thread {
    InputStream input
    int lineCount

    StreamPrinter (InputStream input) {
        this.input = input
    }

    public void run() {
        try {
            BufferedReader bReader = new BufferedReader(new InputStreamReader(input))
            String line

            while ((line = bReader.readLine()) != null) {
                println(line)
                lineCount++
            }
        }
        catch (IOException exception) {
            println("[ERROR] Failed to read process output.")
            exception.printStackTrace()
        }
    }
}
