/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.unix;

import com.urbancode.commons.util.environment.Environment;
import com.urbancode.process.unix.IsExecutable;
import java.io.File;
import java.io.IOException;

class PathSearch {
    private String command;

    public PathSearch(String command) {
        this.command = command;
    }

    public File locate() throws IOException {
        File result = null;
        if (this.command.indexOf(47) != -1) {
            result = new File(this.command).getAbsoluteFile();
        } else {
            try {
                String[] parts;
                String path = Environment.getGlobalInstance().get("PATH");
                for (String part : parts = path.split(":+")) {
                    File file = new File(part, this.command).getAbsoluteFile();
                    if (!new IsExecutable(file).execute()) continue;
                    result = file;
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new IOException("operation interrupted");
            }
        }
        return result;
    }
}

