/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.unix;

import com.urbancode.commons.util.Check;
import com.urbancode.process.NativeProcess;
import java.io.InputStream;
import java.io.OutputStream;

class UnixProcess
extends NativeProcess {
    private OutputStream outputStream;
    private InputStream inputStream;
    private InputStream errorStream;
    private Process delegate;

    UnixProcess(InputStream errorStream, InputStream inputStream, OutputStream outputStream, Process process) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.errorStream = errorStream;
        this.delegate = (Process)Check.nonNull((Object)process, (String)"process");
    }

    public synchronized void destroy() {
        this.delegate.destroy();
    }

    public void destroyTree() {
        this.destroy();
    }

    public int exitValue() {
        return this.delegate.exitValue();
    }

    public int waitFor() throws InterruptedException {
        return this.delegate.waitFor();
    }

    public void releaseResources() {
        this.releaseResources(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void releaseResources(boolean closeStreams) {
        block42: {
            if (!closeStreams) break block42;
            try {
                OutputStream outputStream = this.outputStream;
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception swallow) {
                try {
                    InputStream inputStream = this.inputStream;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception swallow2) {
                }
                finally {
                    try {
                        InputStream errorStream = this.errorStream;
                        if (errorStream != null) {
                            errorStream.close();
                        }
                    }
                    catch (Exception swallow3) {}
                }
            }
            finally {
                block44: {
                    block43: {
                        InputStream inputStream = this.inputStream;
                        if (inputStream == null) break block43;
                        inputStream.close();
                    }
                    try {
                        InputStream errorStream = this.errorStream;
                        if (errorStream != null) {
                            errorStream.close();
                        }
                        break block44;
                    }
                    catch (Exception swallow) {}
                    break block44;
                    catch (Exception swallow) {
                        try {
                            InputStream errorStream = this.errorStream;
                            if (errorStream != null) {
                                errorStream.close();
                            }
                        }
                        catch (Exception swallow4) {}
                        catch (Throwable throwable) {
                            try {
                                InputStream errorStream = this.errorStream;
                                if (errorStream != null) {
                                    errorStream.close();
                                }
                            }
                            catch (Exception swallow5) {}
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

