/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.jboss.helper

class StreamPrinter extends Thread {
    InputStream input
    int lineCount

    StreamPrinter (InputStream input) {
        this.input = input
    }

    public void run() {
        try {
            BufferedReader bReader = new BufferedReader(new InputStreamReader(input))
            String line

            while ((line = bReader.readLine()) != null) {
                println(line)
                lineCount++
            }
        }
        catch (IOException exception) {
            println("[ERROR] Failed to read process output.")
            exception.printStackTrace()
        }
    }
}
