/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import com.urbancode.winapi.LockableResource;
import com.urbancode.winapi.PredefinedHKey;
import com.urbancode.winapi.WinApi;
import com.urbancode.winapi.WindowsException;

public class HKey
extends LockableResource {
    public static final HKey CLASSES_ROOT = new PredefinedHKey(0x80000000L);
    public static final HKey CURRENT_USER = new PredefinedHKey(0x80000001L);
    public static final HKey LOCAL_MACHINE = new PredefinedHKey(0x80000002L);
    public static final HKey USERS = new PredefinedHKey(0x80000003L);
    public static final HKey PERFORMANCE_DATA = new PredefinedHKey(0x80000004L);
    public static final HKey PERFORMANCE_TEXT = new PredefinedHKey(0x80000050L);
    public static final HKey PERFORMANCE_NLSTEXT = new PredefinedHKey(0x80000060L);
    public static final HKey CURRENT_CONFIG = new PredefinedHKey(0x80000005L);
    public static final HKey DYN_DATA = new PredefinedHKey(0x80000006L);
    private volatile long value;

    HKey(long value) {
        this.value = value;
    }

    HKey() {
    }

    public boolean isOpen() {
        return this.value != 0L;
    }

    public void closeNoError() {
        try {
            this.close();
        }
        catch (WindowsException windowsException) {
            // empty catch block
        }
    }

    public void close() throws WindowsException {
        WinApi.RegCloseKey(this);
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            WinApi.closeInFinalizer(this);
        }
    }
}

