import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.jboss.helper.JBossHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def isWindows = apTool.isWindows

def jbossPath = props['jbosspath']
def host = props['host']
def server = props['server']
def group = props['group']
def autoStart = props['autoStart'].toBoolean()
def socketOffset = props['socketOffset']
def cli = isWindows ? "jboss-cli.bat" : "jboss-cli.sh"
def controller = props['controller'] != null ? props['controller'] : ""

def pathFile = new File(jbossPath)
def cliFile = new File(pathFile, cli)

if (!cliFile.isFile()) {
    executable = isWindows ? "jboss-admin.bat" : "jboss-admin.sh"
    cliFile = new File(pathFile, executable)
    
    if (!cliFile.isFile()) {
        throw new Exception("Could not find JBoss executable")
    }
}

def cmdArgs = [cliFile.absolutePath]

if (controller?.trim()?.size() > 0) {
    cmdArgs << "--controller=${controller}"
}

def helper = new JBossHelper(cmdArgs)

def scriptData = helper.createTempFile()

scriptData.withWriter { out ->
    out << "connect\n"
    out << "/host=${host}/server-config=${server}:add(group=${group},auto-start=${autoStart},socket-binding-port-offset=${socketOffset}"
}

cmdArgs << "--file=${scriptData.absolutePath}"

helper.runServerCommand("Creating Server in JBoss")

System.exit(0)
