/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.query;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.query.QueryFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class SimpleQueryFilter
implements QueryFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String filterField;
    private final String filterType;
    private final String filterValue;
    private final int pageNumber;
    private final int rowsPerPage;

    public SimpleQueryFilter(String filterField, String filterType, String filterValue, int pageNumber, int rowsPerPage) {
        this.filterField = filterField == null ? null : filterField.trim();
        this.filterType = filterType == null ? null : filterType.trim();
        this.filterValue = filterValue == null ? null : filterValue.trim();
        this.pageNumber = pageNumber;
        this.rowsPerPage = rowsPerPage;
        this.validate();
    }

    @Override
    public boolean isDescending() {
        return false;
    }

    @Override
    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getStartRecord() {
        return (this.getPageNumber() - 1) * this.getRowsPerPage();
    }

    @Override
    public String getOrderField() {
        return this.filterField;
    }

    @Override
    public List<String> getFilterValues(String name) {
        return Collections.singletonList(this.filterValue);
    }

    @Override
    public String getFilterType(String name) {
        return this.filterType;
    }

    @Override
    public Set<String> getFilterFieldNames() {
        return Collections.singleton(this.filterField);
    }

    private void validate() {
        Check.nonNull(this.filterField, "filterField");
        Check.nonNull(this.filterType, "filterType");
        Check.nonNull(this.filterValue, "filterValue");
        if (this.pageNumber <= 0) {
            throw new IllegalArgumentException("Invalid page number.");
        }
        if (this.rowsPerPage <= 0) {
            throw new IllegalArgumentException("Invalid rows per page.");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.validate();
    }
}

