import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.jboss.helper.JBossHelper
import com.urbancode.commons.fileutils.filelister.*

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def isWindows = apTool.isWindows

def jbossPath = props['jbosspath']
def allServerGroups = props['allServerGroups'] != null ? props['allServerGroups'].toBoolean() : false
def serverGroups = props['serverGroups'] != null ? props['serverGroups'] : ""
def controller = props['controller'] != null ? props['controller'] : ""
def cli = isWindows ? "jboss-cli.bat" : "jboss-cli.sh"

def pathFile = new File(jbossPath)
def cliFile = new File(pathFile, cli)

if (!cliFile.isFile()) {
    executable = isWindows ? "jboss-admin.bat" : "jboss-admin.sh"
    cliFile = new File(pathFile, executable)
    
    if (!cliFile.isFile()) {
        throw new Exception("Could not find JBoss executable")
    }
}

def baseCmdArgs = [cliFile.absolutePath]

if (controller?.trim()?.size() > 0) {
    baseCmdArgs << "--controller=${controller}"
}

def helper = new JBossHelper(baseCmdArgs)

def listFiles(def props) {
    def result = []
    def workDir = new File('.').canonicalFile
    def includes = props['includes']
    def excludes = props['excludes']
    FileListerBuilder flb = new FileListerBuilder(workDir)
    if (includes) {
        flb.include(includes.tokenize("\n") as String[])
    }
    if (excludes) {
        flb.exclude(excludes.tokenize("\n") as String[])
    }
    FileLister fl = flb.build()
    def unparsedList = fl.list()
    for (typedFile in unparsedList) {
        def newFile = new File(typedFile.path())
        if (newFile.isFile()) {
            println "found ${typedFile.path()}"
            result << newFile
        }
    }
    return result
}
def fileList = listFiles(props)

for (srcFile in fileList) {
    def appName = props['appName']
    def scriptData = helper.createTempFile()
    def cmdArgs = baseCmdArgs
    scriptData.withWriter { out ->
        out << "connect\n"
        out << "deploy "
        out << "\"${srcFile.absolutePath}\""
        if (!appName) {
            appName = srcFile.getName().replaceFirst("[.][^.]+\$", "");
        }
        out << " --name=${appName}"
    
        if (allServerGroups) {
            out << " --all-server-groups"
        }
        else if (serverGroups?.trim()?.size() > 0) {
            out << " --server-groups=${serverGroups}"
        }
    }
    cmdArgs << "--file=${scriptData.absolutePath}"
    
    helper.runDeployCommand("Deploying Application/Jar to JBoss")
    cmdArgs.pop()
}

System.exit(0)
