import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.jboss.helper.JBossHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def isWindows = apTool.isWindows

def source = props['source']
def jbossPath = props['jbosspath']
def deployName = props['deployName']
def serverName = props['serverName']
def hostName = props['hostName']
def cli = isWindows ? "jboss-cli.bat" : "jboss-cli.sh"
def controller = props['controller'] != null ? props['controller'] : ""

def pathFile = new File(jbossPath)
def cliFile = new File(pathFile, cli)

if (!cliFile.isFile()) {
    executable = isWindows ? "jboss-admin.bat" : "jboss-admin.sh"
    cliFile = new File(pathFile, executable)
    
    if (!cliFile.isFile()) {
        throw new Exception("Could not find JBoss executable")
    }
}

def cmdArgs = [cliFile.absolutePath]

if (controller?.trim()?.size() > 0) {
    cmdArgs << "--controller=${controller}"
}

def helper = new JBossHelper(cmdArgs)

def scriptData = helper.createTempFile()

scriptData.withWriter { out ->
    out << "connect\n"
    if (hostName?.trim()?.size() == 0) {
        out << "/deployment=${deployName}:read-resource"
    }
    else {
        out << "/host=${hostName}/server=${serverName}/deployment=${deployName}:read-resource"
    }

}
cmdArgs << "--file=${scriptData.absolutePath}"

helper.runScriptCommand("Checking Status of Deployment ${deployName}")

System.exit(0)
