/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.jdk7;

import com.urbancode.commons.util.Check;
import com.urbancode.process.ProcessBuilderImpl;
import com.urbancode.process.ProcessBuilderImplFactory;
import com.urbancode.process.unix.UnixProcessBuilderImplFactory;
import com.urbancode.process.windows.WindowsProcessBuilderImplFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBuilder {
    private static final ProcessBuilderImplFactory factory;
    private List<String> command;
    private Map<String, String> environment = ProcessBuilder.systemEnvironment();
    private File directory;
    private boolean redirectErrorStream;
    private Redirect redirectInput = Redirect.PIPE;
    private Redirect redirectOutput = Redirect.PIPE;
    private Redirect redirectError = Redirect.PIPE;

    private static Map<String, String> systemEnvironment() {
        java.lang.ProcessBuilder jdkBuilder = new java.lang.ProcessBuilder(new String[0]);
        return jdkBuilder.environment();
    }

    public ProcessBuilder(List<String> command) {
        this.command = (List)Check.nonNull(command, (String)"command");
    }

    public ProcessBuilder(String ... command) {
        this.command = new ArrayList<String>(Arrays.asList(command));
    }

    public ProcessBuilder command(List<String> command) {
        this.command = (List)Check.nonNull(command, (String)"command");
        return this;
    }

    public ProcessBuilder command(String ... command) {
        this.command = new ArrayList<String>(Arrays.asList(command));
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File directory) {
        this.directory = directory;
        return this;
    }

    public ProcessBuilder redirectInput(Redirect source) {
        Redirect.Type type = source.type();
        if (type == Redirect.Type.WRITE || type == Redirect.Type.APPEND) {
            throw new IllegalArgumentException();
        }
        if (type == Redirect.Type.INHERIT) {
            throw new UnsupportedOperationException();
        }
        this.redirectInput = source;
        return this;
    }

    public ProcessBuilder redirectOutput(Redirect destination) {
        Redirect.Type type = destination.type();
        if (type == Redirect.Type.READ) {
            throw new IllegalArgumentException();
        }
        if (type == Redirect.Type.INHERIT) {
            throw new UnsupportedOperationException();
        }
        this.redirectOutput = destination;
        return this;
    }

    public ProcessBuilder redirectError(Redirect destination) {
        Redirect.Type type = destination.type();
        if (type == Redirect.Type.READ) {
            throw new IllegalArgumentException();
        }
        if (type == Redirect.Type.INHERIT) {
            throw new UnsupportedOperationException();
        }
        this.redirectError = destination;
        return this;
    }

    public ProcessBuilder redirectInput(File file) {
        return this.redirectInput(Redirect.from(file));
    }

    public ProcessBuilder redirectOutput(File file) {
        return this.redirectOutput(Redirect.to(file));
    }

    public ProcessBuilder redirectError(File file) {
        return this.redirectError(Redirect.to(file));
    }

    public Redirect redirectInput() {
        return this.redirectInput;
    }

    public Redirect redirectOutput() {
        return this.redirectOutput;
    }

    public Redirect redirectError() {
        return this.redirectError;
    }

    public ProcessBuilder inheritIO() {
        throw new UnsupportedOperationException();
    }

    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public Process start() throws IOException {
        ProcessBuilderImpl impl = factory.newImpl(this);
        return impl.start();
    }

    static {
        String os = System.getProperty("os.name").toLowerCase(Locale.US);
        factory = os.indexOf("windows") != -1 ? new WindowsProcessBuilderImplFactory() : new UnixProcessBuilderImplFactory();
    }

    public static abstract class Redirect {
        public static final Redirect PIPE = new Redirect(){

            public Type type() {
                return Type.PIPE;
            }

            public String toString() {
                return this.type().toString();
            }
        };
        public static final Redirect INHERIT = new Redirect(){

            public Type type() {
                return Type.INHERIT;
            }

            public String toString() {
                return this.type().toString();
            }
        };

        public static Redirect from(final File file) {
            Check.nonNull((Object)file, (String)"file");
            return new Redirect(){

                public Type type() {
                    return Type.READ;
                }

                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to read from file \"" + file + "\"";
                }
            };
        }

        public static Redirect to(final File file) {
            Check.nonNull((Object)file, (String)"file");
            return new Redirect(){

                public Type type() {
                    return Type.WRITE;
                }

                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to write to file \"" + file + "\"";
                }
            };
        }

        public static Redirect appendTo(final File file) {
            Check.nonNull((Object)file, (String)"file");
            return new Redirect(){

                public Type type() {
                    return Type.APPEND;
                }

                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to append to file \"" + file + "\"";
                }
            };
        }

        public abstract Type type();

        public File file() {
            return null;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof Redirect) {
                Redirect rhs = (Redirect)obj;
                File file = this.file();
                File rhsFile = rhs.file();
                result = this.type() == rhs.type() && (file == null ? rhsFile == null : file.equals(rhsFile));
            }
            return result;
        }

        public int hashCode() {
            int result = 37;
            File file = this.file();
            result = 13 * result + this.type().hashCode();
            result = 13 * result + (file == null ? 0 : file.hashCode());
            return result;
        }

        private Redirect() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            PIPE,
            INHERIT,
            READ,
            WRITE,
            APPEND;

        }
    }
}

