/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.windows;

import com.urbancode.commons.util.IO;
import com.urbancode.process.ProcessBuilderImpl;
import com.urbancode.process.jdk7.ProcessBuilder;
import com.urbancode.process.windows.WindowsProcess;
import com.urbancode.winapi.CreateProcessUtil;
import com.urbancode.winapi.Handle;
import com.urbancode.winapi.HandleInputStream;
import com.urbancode.winapi.HandleOutputStream;
import com.urbancode.winapi.PathUtil;
import com.urbancode.winapi.ProcessInformation;
import com.urbancode.winapi.RefInt;
import com.urbancode.winapi.SecurityAttributes;
import com.urbancode.winapi.StartupInfo;
import com.urbancode.winapi.WinApi;
import com.urbancode.winapi.WindowsException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WindowsProcessBuilderImpl
extends ProcessBuilderImpl {
    private static final Logger log = Logger.getLogger(WindowsProcessBuilderImpl.class);
    private static final Object startLock = new Object();
    private Handle errorHandle;
    private Handle inputHandle;
    private Handle outputHandle;
    private InputStream errorStream;
    private InputStream inputStream;
    private OutputStream outputStream;

    WindowsProcessBuilderImpl(ProcessBuilder builder) {
        super(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsProcess start() throws IOException {
        WindowsProcess result;
        Object object = startLock;
        synchronized (object) {
            boolean successful = false;
            try {
                this.prepareInput();
                this.prepareError();
                this.prepareOutput();
                ProcessInformation procInfo = this.createProcess();
                this.outputHandle.closeNoError();
                this.inputHandle.closeNoError();
                this.errorHandle.closeNoError();
                procInfo.getThread().closeNoError();
                result = new WindowsProcess(this.outputStream, this.inputStream, this.errorStream, procInfo.getProcess(), procInfo.getProcessId());
                successful = true;
            }
            catch (WindowsException e) {
                if (e.getCode() == 2) {
                    throw new IOException("File not found: " + (String)this.command.get(0));
                }
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            finally {
                if (!successful) {
                    this.cleanupFailure();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFailure() {
        try {
            IO.close((OutputStream)this.outputStream);
        }
        finally {
            try {
                IO.close((InputStream)this.inputStream);
            }
            finally {
                IO.close((InputStream)this.errorStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessInformation createProcess() throws WindowsException {
        StartupInfo startupInfo = new StartupInfo();
        startupInfo.setFlags(256);
        startupInfo.setStdInput(this.outputHandle);
        startupInfo.setStdOutput(this.inputHandle);
        startupInfo.setStdError(this.errorHandle);
        String command = CreateProcessUtil.createCommandLine((List)this.command);
        String environment = CreateProcessUtil.createEnvironment((Map)this.environment);
        String directory = this.directory != null ? this.directory.getPath() : null;
        ProcessInformation procInfo = new ProcessInformation();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating native process");
        }
        Handle stdOut = WinApi.GetStdHandle((int)-11);
        Handle stdIn = WinApi.GetStdHandle((int)-10);
        Handle stdError = WinApi.GetStdHandle((int)-12);
        int stdOutFlags = this.saveHandleInheritanceAndDisable(stdOut);
        int stdInFlags = this.saveHandleInheritanceAndDisable(stdIn);
        int stdErrorFlags = this.saveHandleInheritanceAndDisable(stdError);
        try {
            WinApi.CreateProcess(null, (String)command, null, null, (boolean)true, (int)0x8000400, (String)environment, (String)directory, (StartupInfo)startupInfo, (ProcessInformation)procInfo);
        }
        finally {
            this.restoreHandleInheritance(stdError, stdErrorFlags);
            this.restoreHandleInheritance(stdIn, stdInFlags);
            this.restoreHandleInheritance(stdOut, stdOutFlags);
        }
        return procInfo;
    }

    private void prepareOutput() throws WindowsException {
        if (this.redirectInput.type() == ProcessBuilder.Redirect.Type.PIPE) {
            Handle[] handles = this.openInputPipe();
            this.outputStream = new HandleOutputStream(handles[1], true);
            this.outputHandle = handles[0];
        } else if (this.redirectInput.type() == ProcessBuilder.Redirect.Type.READ) {
            File file = this.redirectInput.file();
            this.outputHandle = this.openInputFile(file.getPath());
        } else {
            throw new AssertionError();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Output handle initialized");
        }
    }

    private void prepareInput() throws WindowsException {
        if (this.redirectOutput.type() == ProcessBuilder.Redirect.Type.PIPE) {
            Handle[] handles = this.openOutputPipe();
            this.inputStream = new HandleInputStream(handles[0], true);
            this.inputHandle = handles[1];
        } else if (this.redirectOutput.type() == ProcessBuilder.Redirect.Type.WRITE) {
            File file = this.redirectOutput.file();
            this.inputHandle = this.openOutputFile(file.getPath(), false);
        } else if (this.redirectOutput.type() == ProcessBuilder.Redirect.Type.APPEND) {
            File file = this.redirectOutput.file();
            this.inputHandle = this.openOutputFile(file.getPath(), true);
        } else {
            throw new AssertionError();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Input handle initialized");
        }
    }

    private void prepareError() throws WindowsException {
        if (this.redirectErrorStream) {
            Handle handle = new Handle();
            WinApi.DuplicateHandle((Handle)WinApi.GetCurrentProcess(), (Handle)this.inputHandle, (Handle)WinApi.GetCurrentProcess(), (Handle)handle, (int)0, (boolean)true, (int)2);
            this.errorHandle = handle;
        } else if (this.redirectError.type() == ProcessBuilder.Redirect.Type.PIPE) {
            Handle[] handles = this.openOutputPipe();
            this.errorStream = new HandleInputStream(handles[0], true);
            this.errorHandle = handles[1];
        } else if (this.redirectError.type() == ProcessBuilder.Redirect.Type.WRITE) {
            File file = this.redirectError.file();
            this.errorHandle = this.openOutputFile(file.getPath(), false);
        } else if (this.redirectError.type() == ProcessBuilder.Redirect.Type.APPEND) {
            File file = this.redirectError.file();
            this.errorHandle = this.openOutputFile(file.getPath(), true);
        } else {
            throw new AssertionError();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Error handle initialized");
        }
    }

    private Handle openInputFile(String path) throws WindowsException {
        SecurityAttributes sa = new SecurityAttributes();
        sa.setInheritHandle(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening native file for " + path));
        }
        path = PathUtil.createLongPath((String)path);
        return WinApi.CreateFile((String)path, (int)Integer.MIN_VALUE, (int)3, (SecurityAttributes)sa, (int)3, (int)128, null, null);
    }

    private Handle openOutputFile(String path, boolean append) throws WindowsException {
        SecurityAttributes sa = new SecurityAttributes();
        sa.setInheritHandle(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Opening native file for " + path));
        }
        if (!PathUtil.isSpecialFile((String)path)) {
            path = PathUtil.createLongPath((String)path);
        }
        Handle handle = WinApi.CreateFile((String)path, (int)0x40000000, (int)3, (SecurityAttributes)sa, (int)4, (int)128, null, null);
        if (!PathUtil.isSpecialFile((String)path)) {
            if (append) {
                WinApi.SetFilePointerEx((Handle)handle, (long)0L, null, (int)2);
            } else {
                WinApi.SetEndOfFile((Handle)handle);
            }
        }
        return handle;
    }

    private Handle[] openOutputPipe() throws WindowsException {
        SecurityAttributes sa = new SecurityAttributes();
        sa.setInheritHandle(true);
        Handle r = new Handle();
        Handle w = new Handle();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Opening native pipe for output");
        }
        WinApi.CreatePipe((Handle)r, (Handle)w, (SecurityAttributes)sa, (int)512);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Pipe opened");
        }
        WinApi.SetHandleInformation((Handle)r, (int)1, (int)0);
        return new Handle[]{r, w};
    }

    private Handle[] openInputPipe() throws WindowsException {
        SecurityAttributes sa = new SecurityAttributes();
        sa.setInheritHandle(true);
        Handle r = new Handle();
        Handle w = new Handle();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Opening native pipe for input");
        }
        WinApi.CreatePipe((Handle)r, (Handle)w, (SecurityAttributes)sa, (int)512);
        WinApi.SetHandleInformation((Handle)w, (int)1, (int)0);
        return new Handle[]{r, w};
    }

    private int saveHandleInheritanceAndDisable(Handle handle) throws WindowsException {
        int result = 0;
        if (handle != null) {
            RefInt flags = new RefInt();
            WinApi.GetHandleInformation((Handle)handle, (RefInt)flags);
            int type = WinApi.GetFileType((Handle)handle);
            if (type != 2) {
                WinApi.SetHandleInformation((Handle)handle, (int)1, (int)0);
            }
            result = flags.intValue();
        }
        return result;
    }

    private void restoreHandleInheritance(Handle handle, int flags) throws WindowsException {
        int type;
        if (handle != null && (type = WinApi.GetFileType((Handle)handle)) != 2) {
            WinApi.SetHandleInformation((Handle)handle, (int)1, (int)flags);
        }
    }
}

