/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.jboss.helper.JBossHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

final def isWindows = apTool.isWindows

def jbossPath = props['jbosspath']
def xaSource = props['xaSource'].toBoolean()
def sourceName = props['sourceName']
def driverName = props['driverName']
def connectionUrl = props['connectionUrl']
def userName = props['userName']
def password = props['password']
def jndiName = props['jndiName']
def enabled = props['enabled'].toBoolean()
def serverName = props['serverName']
def portNumber = props['portNumber']
def databaseName = props['databaseName']
def additionalProps = props['additionalProps'].split('\n') as List
def cli = isWindows ? "jboss-cli.bat" : "jboss-cli.sh"
def controller = props['controller'] != null ? props['controller'] : ""
def jbossUsername = props['jbossUsername'] != null ? props['jbossUsername'] : ""
def jbossPassword = props['jbossPassword'] != null ? props['jbossPassword'] : ""

def pathFile = new File(jbossPath)
def cliFile = new File(pathFile, cli)

if (!cliFile.isFile()) {
    executable = isWindows ? "jboss-admin.bat" : "jboss-admin.sh"
    cliFile = new File(pathFile, executable)

    if (!cliFile.isFile()) {
        throw new Exception("Could not find JBoss executable")
    }
}

def cmdArgs = [cliFile.absolutePath]

if (controller?.trim()?.size() > 0) {
    cmdArgs << "--controller=${controller}"
}

if (jbossUsername) {
    cmdArgs << "--user=${jbossUsername}"
}

if (jbossPassword) {
    cmdArgs << "--password=${jbossPassword}"
}

def helper = new JBossHelper(cmdArgs)

def scriptData = helper.createTempFile()

scriptData.withWriter { out ->

    out << "connect\n"

    if (!xaSource) {
        println "Creating a data source"
        out << "data-source add --name=${sourceName} --driver-name=${driverName} --connection-url=${connectionUrl} "
        out << "--jndi-name=${jndiName} --user-name=${userName} --password=${password}\n"
        if (enabled) {
            println "starting the data source enabled"
            out << "/subsystem=datasources/data-source=${sourceName}:enable"
        }
    }
    else {
        println "Creating an XA data source"
        out << "xa-data-source add --name=${sourceName} --driver-name=${driverName} --jndi-name=${jndiName} "
        out << "--user-name=${userName} --password=${password}"

        if (additionalProps.size() > 0) {
            for (prop in additionalProps) {
                scriptData << " ${prop}"
            }
        }

        out << "\n"
        out << "/subsystem=datasources/xa-data-source=${sourceName}/xa-datasource-properties=ServerName:add(value=${serverName})\n"
        out << "/subsystem=datasources/xa-data-source=${sourceName}/xa-datasource-properties=PortNumber:add(value=${portNumber})\n"
        out << "/subsystem=datasources/xa-data-source=${sourceName}/xa-datasource-properties=DatabaseName:add(value=${databaseName})\n"
        if (enabled) {
            println "starting the data source enabled"
            out << "\nxa-data-source enable --name=${sourceName}"
        }

    }

}

cmdArgs << "--file=${scriptData.absolutePath}"

helper.runSourceCommand("Creating data source on JBoss")

System.exit(0)
