/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.windows;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.environment.Environment;
import com.urbancode.process.NativeProcess;
import com.urbancode.process.jdk7.ProcessBuilder;
import com.urbancode.shell.impersonation.windows.ImpersonaterStatus;
import com.urbancode.shell.impersonation.windows.InvalidLineEndingException;
import com.urbancode.shell.impersonation.windows.InvalidStatusLineException;
import com.urbancode.winapi.CreateProcessUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Impersonater {
    private static final Logger log = Logger.getLogger(Impersonater.class);
    private static final String EXECUTABLE = System.getProperty("com.urbancode.shell.impersonation.windows.Impersonater", "Impersonater.exe");
    private static final Pattern STATUS_PATTERN = Pattern.compile("(\\d+) (.+)");
    static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final String command;
    private NativeProcess process;
    private ImpersonaterStatus status;
    private InputStream in;
    private Writer out;

    public Impersonater(String command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.command = command;
    }

    public NativeProcess getProcess() {
        if (this.process == null) {
            throw new IllegalStateException();
        }
        return this.process;
    }

    public void execute() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[]{EXECUTABLE, this.command});
        Environment.getGlobalInstance().copyTo(builder.environment());
        this.process = (NativeProcess)builder.start();
        this.out = new OutputStreamWriter(this.process.getOutputStream(), US_ASCII);
        this.in = this.process.getInputStream();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Process started");
        }
    }

    public void configurationComplete() throws IOException {
        this.writeConfigurationEnd();
        this.readAndSetStatus();
        this.cleanupIfImpersonaterFailed();
    }

    public ImpersonaterStatus getStatus() {
        if (this.status == null) {
            throw new IllegalStateException();
        }
        return this.status;
    }

    public void setUser(String user) throws IOException {
        this.writeStringOption("User", user);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User=" + user));
        }
    }

    public void setDomain(String domain) throws IOException {
        this.writeStringOption("Domain", domain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Domain=" + domain));
        }
    }

    public void setPassword(String password) throws IOException {
        this.writeStringOption("Password", password);
        if (log.isDebugEnabled()) {
            if (password != null) {
                char[] obscure = new char[password.length()];
                Arrays.fill(obscure, '*');
                log.debug((Object)("Password=" + new String(obscure)));
            } else {
                log.debug((Object)"Password=null");
            }
        }
    }

    public void setWindowStation(String windowStation) throws IOException {
        if (windowStation == null) {
            throw new NullPointerException("windowStation");
        }
        this.writeStringOption("WindowStation", windowStation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("WindowStation=" + windowStation));
        }
    }

    public void setDesktop(String desktop) throws IOException {
        if (desktop == null) {
            throw new NullPointerException("desktop");
        }
        this.writeStringOption("Desktop", desktop);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Desktop=" + desktop));
        }
    }

    public void setDirectory(String directory) throws IOException {
        this.writeStringOption("Directory", directory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Directory=" + directory));
        }
    }

    public void setCommand(String command) throws IOException {
        if (command != null) {
            command = new File(command).toString();
        }
        this.writeStringOption("Command", command);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command=" + command));
        }
    }

    public void setCommandLine(List<String> commandLine) throws IOException {
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        this.writeStringOption("CommandLine", CreateProcessUtil.createCommandLine(commandLine));
        if (log.isDebugEnabled()) {
            log.debug((Object)("CommandLine=" + commandLine));
        }
    }

    public void setEnvironment(Map<String, String> environment) throws IOException {
        if (environment == null) {
            this.writeOption("Env", "null");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Env=null");
            }
        } else if (environment.isEmpty()) {
            this.writeOption("Env", "empty");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Env=empty");
            }
        } else {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                this.writeStringOption("Env", entry.getKey() + "=" + entry.getValue());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Env=" + environment.keySet()));
            }
        }
    }

    public void setInput(ProcessBuilder.Redirect redirect) throws IOException {
        if (redirect == null) {
            throw new NullPointerException();
        }
        ProcessBuilder.Redirect.Type type = redirect.type();
        if (type != ProcessBuilder.Redirect.Type.PIPE && type != ProcessBuilder.Redirect.Type.READ) {
            throw new IllegalArgumentException();
        }
        this.writeRedirectOption("Input", redirect);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input=" + redirect));
        }
    }

    public void setOutput(ProcessBuilder.Redirect redirect) throws IOException {
        if (redirect == null) {
            throw new NullPointerException();
        }
        ProcessBuilder.Redirect.Type type = redirect.type();
        if (type != ProcessBuilder.Redirect.Type.PIPE && type != ProcessBuilder.Redirect.Type.WRITE && type != ProcessBuilder.Redirect.Type.APPEND) {
            throw new IllegalArgumentException();
        }
        this.writeRedirectOption("Output", redirect);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Output=" + redirect));
        }
    }

    public void setError(ProcessBuilder.Redirect redirect) throws IOException {
        ProcessBuilder.Redirect.Type type;
        if (redirect != null && (type = redirect.type()) != ProcessBuilder.Redirect.Type.PIPE && type != ProcessBuilder.Redirect.Type.WRITE && type != ProcessBuilder.Redirect.Type.APPEND) {
            throw new IllegalArgumentException();
        }
        this.writeRedirectOption("Error", redirect);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Error=" + redirect));
        }
    }

    private void writeStringOption(String option, String argument) throws IOException {
        if (option == null) {
            throw new NullPointerException();
        }
        this.out.write(option);
        this.out.write(32);
        this.writeString(argument);
        this.out.write(10);
    }

    private void writeOption(String option, String argument) throws IOException {
        if (option == null) {
            throw new NullPointerException();
        }
        if (argument == null) {
            throw new NullPointerException();
        }
        this.out.write(option);
        this.out.write(32);
        this.out.write(argument);
        this.out.write(10);
    }

    private void writeRedirectOption(String option, ProcessBuilder.Redirect redirect) throws IOException {
        this.out.write(option);
        this.out.write(32);
        if (redirect == null) {
            this.out.write("merge");
        } else {
            switch (redirect.type()) {
                case PIPE: 
                case INHERIT: {
                    this.out.write("pipe");
                    break;
                }
                case READ: 
                case WRITE: {
                    this.out.write("file ");
                    this.writeString(redirect.file().toString());
                    break;
                }
                case APPEND: {
                    this.out.write("append ");
                    this.writeString(redirect.file().toString());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.out.write(10);
    }

    private void writeString(String string) throws IOException {
        if (string == null) {
            this.out.write("null");
        } else {
            this.out.write("\"");
            this.out.write(StringUtil.escapeJava((String)string));
            this.out.write("\"");
        }
    }

    private String readStatusLine() throws IOException {
        int c;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading status");
        }
        StringBuilder builder = new StringBuilder();
        boolean sawCr = false;
        while ((c = this.in.read()) != -1 && c != 10) {
            if (c == 13) {
                sawCr = true;
                continue;
            }
            if (sawCr) {
                throw new InvalidLineEndingException("CR not followed by LF", (char)c);
            }
            builder.append((char)c);
        }
        if (c == -1) {
            throw new EOFException("Premature EOF");
        }
        return builder.toString();
    }

    private void readAndSetStatus() throws IOException {
        Matcher matcher;
        String statusLine = this.readStatusLine();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Status line: \"" + statusLine + "\""));
        }
        if (!(matcher = STATUS_PATTERN.matcher(statusLine)).matches()) {
            throw new InvalidStatusLineException();
        }
        this.status = new ImpersonaterStatus(Integer.parseInt(matcher.group(1)), matcher.group(2));
    }

    private void writeConfigurationEnd() throws IOException {
        this.out.write(10);
        this.out.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Command configuration sent");
        }
    }

    private void cleanupIfImpersonaterFailed() {
        if (!this.status.isOk()) {
            NativeProcess process;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Status indicates failure; cleaning-up process");
            }
            if ((process = this.process) != null) {
                this.process = null;
                this.in = null;
                this.out = null;
                process.releaseResources();
            }
        }
    }
}

