/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CreateProcessUtil {
    public static String createEnvironment(Map<String, String> env) {
        String result = null;
        if (env != null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> v : env.entrySet()) {
                builder.append(v.getKey());
                builder.append('=');
                builder.append(v.getValue());
                builder.append('\u0000');
            }
            if (builder.length() == 0) {
                builder.append('\u0000');
            }
            builder.append('\u0000');
            result = builder.toString();
        }
        return result;
    }

    public static String createEnvironment(String[] strings) {
        String result = null;
        if (strings != null) {
            StringBuilder builder = new StringBuilder();
            for (String string : strings) {
                builder.append(CreateProcessUtil.terminate(string));
            }
            if (builder.length() == 0) {
                builder.append("\u0000");
            }
            builder.append("\u0000");
            result = builder.toString();
        }
        return result;
    }

    public static String createCommandLine(List<String> command) {
        ArrayList<String> commandLine = new ArrayList<String>(command);
        commandLine.set(0, new File((String)commandLine.get(0)).getPath());
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < commandLine.size(); ++i) {
            String s;
            if (i > 0) {
                buffer.append(' ');
            }
            if ((s = (String)commandLine.get(i)).indexOf(32) >= 0 || s.indexOf(9) >= 0) {
                if (s.charAt(0) != '\"') {
                    buffer.append('\"');
                    buffer.append(s);
                    if (s.endsWith("\\")) {
                        buffer.append("\\");
                    }
                    buffer.append('\"');
                    continue;
                }
                if (s.endsWith("\"")) {
                    buffer.append(s);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    private static String terminate(String string) {
        if (string == null) {
            return "\u0000";
        }
        if (string.charAt(string.length() - 1) == '\u0000') {
            return string;
        }
        return string + '\u0000';
    }

    private CreateProcessUtil() {
    }
}

