/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2010, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

/*
 * JIRA REST API Documentation: https://docs.atlassian.com/jira/REST/latest/
 */

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.jira.addcomments.FailMode
import com.urbancode.air.plugin.jira.addcomments.JIRAHelper
import com.urbancode.air.plugin.jira.addcomments.TextUtil
import org.apache.http.impl.client.DefaultHttpClient

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

final def serverUrl = props['serverUrl']
final def username  = props['username']
final def password  = props['passwordScript']?:props['password']
final def issueType = props['issueType']
final def project   = props['project'].trim()
final def statusName = props['statusName']
def proxyHost = props['proxyHost']?.trim()
def proxyPort = props['proxyPort']?.trim()
boolean allowInsecure = (props['allowInsecure']?:"false").toBoolean()

//------------------------------------------------------------------------------
// Script content
//------------------------------------------------------------------------------

println "Server:\t$serverUrl"
println "Status:\t$statusName"
println "Issue Type:\t$issueType"
println ""

// Begin authentication steps with JIRA
JIRAHelper jira = new JIRAHelper()
DefaultHttpClient client
client = jira.createClient(username, password, proxyHost, proxyPort, allowInsecure)

boolean issuesFound = jira.areIssuesFound(client, serverUrl, project, issueType, statusName)

if(issuesFound) {
	println("Issues found, Hence marking it as failure.")
	System.exit(-1)
}else {
	println("No Issues found, Hence marking it as success.")
}
