package com.urbancode.air.plugin.jira.addcomments

/**
 * @author mbeshara
 *
 */
class TextUtil {

    /**
     * Converts a string into a sorted, unique list of trimmed, nonempty strings. The input string is
     * delimited by commas and newlines. The resulting list elements can optionally have all whitespace
     * removed.
     *
     * A common use case for this method is to parse step properties of type textAreaBox.
     *
     * @param text The input string containing commas and newlines.
     * @param removeAllWhitespace Default false. If true, remove all whitespace from each list element.
     * @return A sorted, unique list of strings parsed from the input string.
     */
    public static List<String> textToList(String text, boolean removeAllWhitespace = false) {
        if (!text) {
            return []
        }

        List<String> result = text.tokenize(',\n')*.trim()

        if (removeAllWhitespace) {
            result = result*.replaceAll('\\s', '')
        }

        result = result.unique().sort() - ''

        result
    }

}
