/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper;


final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def includes = props['includes'].split('\n');
final def excludes = props['excludes']?.split('\n');
final def mod = props['mod'];
final def fileType = props['fileType'];

def failures = [];

def ant = new AntBuilder();

println "Chmodding to $mod files of type $fileType with includes :"
includes.each {
    println "\t" + it;
}
println "and excludes :" 
excludes.each {
    println "\t" + it;
}

ant.chmod(perm:mod,type:fileType) {
    fileset(dir:".") {
       for (inc in includes) {
          include(name:inc);
       }
       for (exc in excludes) {
          exclude(name:exc);
       }
    }
}
