/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction;

import com.urbancode.air.plugin_command.redaction.CharSubSequence;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Redactor {
    public static final String MASK = "****";
    private TreeSet<String> secureProperties;
    private String input = "";
    private int index = 0;
    private int secureValuesFound = 0;
    int possibleRedactionRange = -1;
    private Comparator<String> secValComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int compVal = s2.length() > s1.length() ? 1 : (s2.length() < s1.length() ? -1 : s2.compareTo(s1));
            return compVal;
        }
    };

    public Redactor(Collection<String> secureValues) {
        this.secureProperties = new TreeSet<String>(this.secValComparator);
        this.secureProperties.addAll(secureValues);
    }

    public Redactor() {
        this.secureProperties = new TreeSet<String>(this.secValComparator);
    }

    public String redact(Set<String> secureValues, String src) {
        this.clearSecureProperties();
        this.secureProperties.addAll(secureValues);
        return this.redact(src, true);
    }

    public String redact(String src) {
        return this.redact(src, true);
    }

    public String redact(String src, boolean atEndOfInput) {
        this.updateInput(src);
        StringBuilder stringBuilder = new StringBuilder();
        this.updatePossibleRedactionRange();
        if (this.secureProperties.size() == 0 || this.getLongestValue() == 0) {
            String result = this.input;
            this.input = "";
            this.index = 0;
            return result;
        }
        while (this.canRead(atEndOfInput)) {
            CharSequence reading = this.substring(this.input, this.index);
            CharSequence secureValue = this.findMatch(reading);
            if (secureValue == null) {
                if (reading.length() == 0) break;
                stringBuilder.append(this.input.charAt(this.index));
                ++this.index;
                continue;
            }
            if ((secureValue = this.resolveOverlappingSecureValues(secureValue, atEndOfInput)) == null) break;
            for (int i = 0; i < this.secureValuesFound; ++i) {
                stringBuilder.append(MASK);
            }
            this.secureValuesFound = 0;
            this.index += secureValue.length();
        }
        this.trimInput();
        return stringBuilder.toString();
    }

    public String flush() {
        return this.redact("");
    }

    public void addSecureProperty(String secureProp) {
        if (secureProp != null && secureProp.length() > 0) {
            this.secureProperties.add(secureProp);
        }
    }

    public void removeSecureProperty(String secureProp) {
        this.secureProperties.remove(secureProp);
    }

    public void clearSecureProperties() {
        this.secureProperties.clear();
    }

    public void addAll(List<String> secureProps) {
        for (String secureProp : secureProps) {
            this.addSecureProperty(secureProp);
        }
    }

    public boolean canRead(boolean atEnd) {
        return this.canRedactThisValue("", atEnd);
    }

    private CharSequence resolveOverlappingSecureValues(CharSequence initialSecureVal, boolean atEnd) {
        CharSequence secureValue = initialSecureVal;
        block0: for (int i = 0; i < secureValue.length(); ++i) {
            for (String secVal : this.secureProperties) {
                if (this.contains(secureValue, secVal) || !this.startsWith(this.input, secVal, this.index + i)) continue;
                secureValue = this.substring(this.input, this.index, this.index + secVal.length() + i);
                ++this.secureValuesFound;
                continue block0;
            }
        }
        if (!this.canRedactThisValue(secureValue, atEnd)) {
            this.secureValuesFound = 0;
            return null;
        }
        return secureValue;
    }

    private boolean canRedactThisValue(CharSequence secValue, boolean atEnd) {
        return atEnd || this.input.length() - this.index - secValue.length() > this.possibleRedactionRange;
    }

    private String findMatch(CharSequence reading) {
        for (String value : this.secureProperties) {
            if (!this.startsWith(reading, value, 0)) continue;
            this.secureValuesFound = 1;
            return value;
        }
        return null;
    }

    private CharSequence substring(CharSequence s, int start) {
        return new CharSubSequence(s, start, s.length());
    }

    private CharSequence substring(CharSequence s, int start, int end) {
        return new CharSubSequence(s, start, end);
    }

    private boolean startsWith(CharSequence source, CharSequence target, int offset) {
        int tlen = target.length();
        if (offset < 0 || offset > source.length() - tlen) {
            return false;
        }
        int ti = 0;
        int si = offset;
        while (ti < tlen) {
            if (source.charAt(si) != target.charAt(ti)) {
                return false;
            }
            ++ti;
            ++si;
        }
        return true;
    }

    private boolean contains(CharSequence source, CharSequence target) {
        int tlen;
        if (source == null || target == null) {
            return false;
        }
        int slen = source.length();
        if (slen < (tlen = target.length())) {
            return false;
        }
        if (tlen == 0) {
            return true;
        }
        char first = target.charAt(0);
        int max = slen - tlen;
        for (int si = 0; si <= max; ++si) {
            while (si <= max && source.charAt(si) != first) {
                ++si;
            }
            if (si > max) continue;
            int sj = si + 1;
            int ti = 1;
            int end = sj + tlen - 1;
            while (sj < end && source.charAt(sj) == target.charAt(ti)) {
                ++sj;
                ++ti;
            }
            if (sj != end) continue;
            return true;
        }
        return false;
    }

    private void trimInput() {
        this.input = this.input.substring(this.index);
        this.index = 0;
    }

    private int getLongestValue() {
        if (this.secureProperties.size() == 0) {
            return 0;
        }
        String longest = this.secureProperties.first();
        if (longest == null) {
            return 0;
        }
        return longest.length();
    }

    private void updateInput(String in) {
        this.input = this.input + in;
    }

    private void updatePossibleRedactionRange() {
        this.possibleRedactionRange = this.getLongestValue() * 2 - 1;
    }
}

