/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.Arg;
import com.urbancode.air.plugin_command.AutomationPlugin;
import com.urbancode.air.plugin_command.Command;
import com.urbancode.air.plugin_command.CommandLine;
import com.urbancode.air.plugin_command.postprocess.PostProcessRuntime;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.properties.PropertyResolver;
import com.urbancode.air.plugin_command.properties.PropertyValueMissingException;
import com.urbancode.air.plugin_command.properties.PropertyValueScope;
import com.urbancode.air.plugin_command.properties.RequiredPropertyValidator;
import com.urbancode.air.plugin_command.redaction.RedactingPrintStream;
import com.urbancode.air.plugin_command.runtime.AutomationPluginRuntimeException;
import com.urbancode.air.plugin_command.runtime.CacheEntry;
import com.urbancode.air.plugin_command.runtime.CacheManager;
import com.urbancode.air.plugin_command.runtime.Fetcher;
import com.urbancode.air.plugin_command.runtime.FetcherHttp;
import com.urbancode.air.plugin_command.runtime.FileFactory;
import com.urbancode.air.plugin_command.runtime.HttpConnectionSettings;
import com.urbancode.air.plugin_command.runtime.PluginJavaOpts;
import com.urbancode.air.plugin_command.runtime.ShellHelper;
import com.urbancode.air.plugin_command.runtime.StepExecutionInfo;
import com.urbancode.air.securedata.BadEnvelopeException;
import com.urbancode.air.securedata.Base64Codec;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.SecretContainerImpl;
import com.urbancode.air.securedata.SecretUnavailableException;
import com.urbancode.air.securedata.SecureBlob;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.WildcardToRegex;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.commons.util.windows.CmdUtil;
import com.urbancode.commons.xml.marshall.MarshallingEngine;
import com.urbancode.shell.impersonation.ImpersonationToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationPluginRunnable
implements Runnable {
    private static final Logger logger = Logger.getLogger(AutomationPluginRunnable.class);
    static final String INPUT_PROPS_ARG = "PLUGIN_INPUT_PROPS";
    static final String OUTPUT_PROPS_ARG = "PLUGIN_OUTPUT_PROPS";
    private static final String UCD_ENCRYPT_PROPERTIES_ENV_VAR = "UCD_USE_ENCRYPTED_PROPERTIES";
    private static final String UCD_SECRET_VAR = "ucd.properties.secret";
    private final SecureRandom rand = new SecureRandom();
    protected final CacheManager cacheManager;
    protected final MarshallingEngine marshallingEngine;
    protected final PluginJavaOpts opts;
    protected final boolean displayDetailsInOutput;
    private String pluginId = null;
    private Long pluginVersion = null;
    private String commandName = null;
    private File inputPropFile = null;
    private File envPropFile = null;
    private File outputPropFile = null;
    private File workingDirectory = null;
    private File outputLogFile = null;
    private File errorLogFile = null;
    private Set<String> secureValues = null;
    private Set<String> propertyNamesToKeepEnvVarsIn = null;
    private ImpersonationToken impToken = null;
    private StepExecutionInfo info = null;
    private String postProcBody = null;
    private Properties outputProperties = null;
    private Properties inputProperties = null;
    private Properties envProperties = null;
    private boolean rewriteOutputPropertiesAfterPostProcessingScript = true;
    private boolean disablePropertyFileEncryption = false;
    private final FileFactory fileFactory;

    AutomationPluginRunnable(CacheManager man, MarshallingEngine eng, PluginJavaOpts opts, boolean details, FileFactory fileFactory) {
        this.cacheManager = man;
        this.marshallingEngine = eng;
        this.opts = opts;
        this.displayDetailsInOutput = details;
        this.fileFactory = fileFactory;
    }

    AutomationPluginRunnable(CacheManager man, MarshallingEngine eng, PluginJavaOpts opts, boolean details) {
        this(man, eng, opts, details, new FileFactory());
    }

    public AutomationPluginRunnable rewriteOutputPropertiesAfterPostProcessingScript(boolean rewrite) {
        this.rewriteOutputPropertiesAfterPostProcessingScript = rewrite;
        return this;
    }

    public AutomationPluginRunnable withPluginId(String pluginId) {
        this.pluginId = pluginId;
        return this;
    }

    public AutomationPluginRunnable withPluginVersion(Long version) {
        this.pluginVersion = version;
        return this;
    }

    public AutomationPluginRunnable withCommandName(String name) {
        this.commandName = name;
        return this;
    }

    public AutomationPluginRunnable withInputPropFile(File inputPropFile) {
        this.inputPropFile = inputPropFile;
        return this;
    }

    public AutomationPluginRunnable withEnvPropFile(File file) {
        this.envPropFile = file;
        return this;
    }

    public AutomationPluginRunnable withOutputPropFile(File file) {
        this.outputPropFile = file;
        return this;
    }

    public AutomationPluginRunnable withWorkingDirectory(File file) {
        this.workingDirectory = file;
        return this;
    }

    public AutomationPluginRunnable withOutputLog(File file) {
        this.outputLogFile = file;
        return this;
    }

    public AutomationPluginRunnable withErrorLogFile(File file) {
        this.errorLogFile = file;
        return this;
    }

    public AutomationPluginRunnable withSecureValues(Set<String> values) {
        this.secureValues = values;
        return this;
    }

    public AutomationPluginRunnable withPropertyNamesToKeepEnvVarsIn(Set<String> values) {
        this.propertyNamesToKeepEnvVarsIn = values;
        return this;
    }

    public AutomationPluginRunnable withImpersonationToken(ImpersonationToken token) {
        this.impToken = token;
        return this;
    }

    public AutomationPluginRunnable withStepExecutionInfo(StepExecutionInfo stepInfo) {
        this.info = stepInfo;
        return this;
    }

    public AutomationPluginRunnable withPostProcessingScript(String body) {
        this.postProcBody = body;
        return this;
    }

    public AutomationPluginRunnable withInputProperties(Properties inputProps) {
        this.inputProperties = inputProps;
        return this;
    }

    public AutomationPluginRunnable withEnvironmentProperties(Properties envProps) {
        this.envProperties = envProps;
        return this;
    }

    public AutomationPluginRunnable withDisablePropertyFileEncryption(boolean disableEncryption) {
        this.disablePropertyFileEncryption = disableEncryption;
        return this;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object pluginHomeDirectory;
            Properties inputProps;
            this.validateArgsForExecuteCommand(this.pluginId, this.pluginVersion, this.commandName, this.inputPropFile, this.envPropFile, this.outputPropFile, this.workingDirectory);
            this.createAndValidateLogFiles(this.outputLogFile, this.errorLogFile);
            if (this.propertyNamesToKeepEnvVarsIn == null) {
                this.propertyNamesToKeepEnvVarsIn = new HashSet<String>();
            }
            if ((inputProps = this.inputProperties) == null) {
                inputProps = this.loadProperties(this.inputPropFile, null);
            }
            PropertyValueScope commandPropertyScope = new PropertyValueScope(inputProps);
            Properties envProps = this.envProperties;
            if (envProps == null) {
                envProps = this.loadProperties(this.envPropFile, null);
            }
            this.setupFetcher(envProps);
            Properties outputProperties = new Properties();
            CacheEntry cacheEntry = this.cacheManager.getEntry(this.pluginId, this.pluginVersion);
            try {
                pluginHomeDirectory = cacheEntry.getCacheBase();
                AutomationPlugin automationPlugin = this.loadPluginWithCommand((File)pluginHomeDirectory, this.commandName);
                this.inputPropFile.createNewFile();
                ShellHelper.getInstance().chmodFile(this.inputPropFile, "a+rw");
                this.outputPropFile.createNewFile();
                ShellHelper.getInstance().chmodFile(this.outputPropFile, "a+rw");
                this.configureEnvironmentProperties(envProps, (File)pluginHomeDirectory);
                this.validateRequiredProperties(this.commandName, commandPropertyScope, automationPlugin);
                Command command = automationPlugin.getCommandByName(this.commandName);
                CommandLine commandLine = command.getCommand();
                SecretContainerImpl secret = null;
                if (!this.disablePropertyFileEncryption && automationPlugin.requiresPropertyFileEncryption()) {
                    secret = new SecretContainerImpl(new byte[16]);
                    this.rand.nextBytes(secret.getSecret());
                }
                this.addEnvironmentProperties(commandPropertyScope, envProps, command, (SecretContainer)secret);
                Properties stdInProps = new Properties();
                if (secret != null) {
                    stdInProps.put(UCD_SECRET_VAR, new Base64Codec().encodeToString(secret.getSecret()));
                }
                Properties resolvedCommandProperties = new Properties();
                ArrayList<String> commandArgsList = new ArrayList<String>();
                Properties resolvedEnvProps = new Properties();
                this.resolvePropertiesAndSetupCommandArgs(this.inputPropFile, this.outputPropFile, this.propertyNamesToKeepEnvVarsIn, commandPropertyScope, envProps, (File)pluginHomeDirectory, commandLine, resolvedCommandProperties, commandArgsList, resolvedEnvProps);
                this.storePropertiesFile(this.inputPropFile, resolvedCommandProperties, (SecretContainer)secret);
                RedactingPrintStream redactingOutputPrinter = null;
                try {
                    block43: {
                        redactingOutputPrinter = this.redactingPrintStream(this.outputLogFile, false);
                        this.preprocessCommandLineForOsSpecifics(redactingOutputPrinter, redactingOutputPrinter, resolvedEnvProps, commandArgsList, this.workingDirectory, this.impToken);
                        if (this.displayDetailsInOutput) {
                            this.outputRunDetails(this.workingDirectory, automationPlugin, resolvedEnvProps, commandArgsList, resolvedCommandProperties, redactingOutputPrinter);
                        }
                        File tempDir = this.inputPropFile.getParentFile();
                        if (this.impToken != null) {
                            try {
                                Unix unix = new Unix();
                                unix.chown(this.inputPropFile, this.impToken.getUser());
                                unix.chown(this.outputPropFile, this.impToken.getUser());
                                unix.chown(tempDir, this.impToken.getUser());
                                unix.chmod(this.inputPropFile, 384);
                                unix.chmod(this.outputPropFile, 384);
                                unix.chmod(tempDir, 448);
                            }
                            catch (Exception e) {
                                if (!logger.isDebugEnabled()) break block43;
                                logger.debug((Object)("Failed to change ownership or permission of temporary files for impersonation: " + e.getMessage()));
                                logger.debug((Object)"Using default permissions instead.");
                            }
                        }
                    }
                    Process externalProc = ShellHelper.getInstance().executeShellAndWait(redactingOutputPrinter, redactingOutputPrinter, resolvedEnvProps, commandArgsList, this.workingDirectory, this.impToken, this.info, stdInProps);
                    if (this.outputPropFile.canRead()) {
                        outputProperties = this.loadProperties(this.outputPropFile, (SecretContainer)secret);
                    }
                    int exitValue = 1;
                    if (externalProc != null) {
                        exitValue = externalProc.exitValue();
                    }
                    outputProperties.setProperty("exitCode", String.valueOf(exitValue));
                    boolean defaultPostScript = false;
                    if (this.postProcBody == null || this.postProcBody.length() == 0) {
                        defaultPostScript = true;
                        this.postProcBody = automationPlugin.getPostProcessingScript(this.commandName);
                    }
                    IO.close((OutputStream)redactingOutputPrinter);
                    ByteArrayOutputStream postOutputStream = null;
                    try {
                        postOutputStream = new ByteArrayOutputStream();
                        if (!defaultPostScript) {
                            String consoleMsg = String.format("%n================================================================================%n", new Object[0]);
                            consoleMsg = consoleMsg + String.format("Post Processing Script Execution Console Output:%n%n", new Object[0]);
                            postOutputStream.write(consoleMsg.getBytes());
                        }
                        PostProcessRuntime.evaluate(this.outputLogFile, outputProperties, this.postProcBody, postOutputStream);
                        redactingOutputPrinter = this.redactingPrintStream(this.outputLogFile, true);
                        redactingOutputPrinter.write(postOutputStream.toByteArray());
                    }
                    finally {
                        IO.close((OutputStream)postOutputStream);
                    }
                }
                catch (Throwable throwable) {
                    IO.close(redactingOutputPrinter);
                    throw throwable;
                }
                IO.close((OutputStream)redactingOutputPrinter);
            }
            finally {
                cacheEntry.unlock();
            }
            pluginHomeDirectory = this.info;
            synchronized (pluginHomeDirectory) {
                if (this.info.isAborted()) {
                    outputProperties.setProperty("Status", "PLUGIN_TASK_CANCELLED");
                }
            }
            if (this.rewriteOutputPropertiesAfterPostProcessingScript && this.outputPropFile.canWrite()) {
                FileOutputStream outPropStream = null;
                try {
                    Properties safeOutputProperties = new Properties();
                    for (Map.Entry<Object, Object> entry : outputProperties.entrySet()) {
                        Object entryKey = entry.getKey();
                        Object entryValue = entry.getValue();
                        if (entryKey != null && entryValue != null) {
                            String stringKey = entryKey.toString();
                            String stringValue = entryValue.toString();
                            safeOutputProperties.setProperty(stringKey, stringValue);
                            continue;
                        }
                        logger.error((Object)("Encountered a null property key or value: " + entryKey));
                    }
                    outPropStream = this.fileFactory.outputStream(this.outputPropFile);
                    safeOutputProperties.store(outPropStream, "After Post Process");
                }
                catch (Throwable throwable) {
                    IO.close(outPropStream);
                    throw throwable;
                }
                IO.close((OutputStream)outPropStream);
            }
            if (!outputProperties.containsKey("Status")) {
                logger.trace((Object)"Property 'Status' not returned by plugin task.");
                PrintStream errStream = null;
                try {
                    FileOutputStream errLogStream = this.fileFactory.outputStream(this.errorLogFile);
                    errStream = new PrintStream(errLogStream);
                    errStream.println("Error: Property 'Status' not returned by plugin task. Execution result status indeterminate. Failing task...");
                    errStream.println("    ***NOTE*** If you are using a Post-Process script you must set the 'Status' output property ***NOTE***");
                    errStream.flush();
                    IO.close((OutputStream)errStream);
                }
                catch (Exception ex) {
                    logger.error((Object)"Could not write error to error log!");
                }
                finally {
                    IO.close(errStream);
                }
            }
            this.outputProperties = outputProperties;
        }
        catch (Exception e) {
            PrintStream errStream = null;
            try {
                FileOutputStream errorLogStream = this.fileFactory.outputStream(this.errorLogFile);
                errStream = new PrintStream(errorLogStream);
                e.printStackTrace(errStream);
                IO.close((OutputStream)errStream);
            }
            catch (Exception ex) {
                logger.error((Object)"Could not write exception to error log!");
            }
            finally {
                IO.close(errStream);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private RedactingPrintStream redactingPrintStream(File file, boolean append) throws FileNotFoundException, UnsupportedEncodingException {
        FileOutputStream outputLogStream = this.fileFactory.outputStream(file, append);
        PrintStream outputPrintStream = new PrintStream((OutputStream)outputLogStream, true, IO.utf8().toString());
        return new RedactingPrintStream(outputPrintStream, this.secureValues);
    }

    private void validateArgsForExecuteCommand(String pluginId, Long pluginVersion, String commandName, File inputPropFile, File envPropFile, File outputPropFile, File workingDirectory) throws IOException {
        if (pluginId == null) {
            logger.error((Object)"No pluginId was given to executeCommand().");
            throw new NullPointerException("No pluginId was give to executeCommand()");
        }
        if (pluginVersion == null) {
            logger.error((Object)"No pluginVersion was given to executeCommand().");
            throw new NullPointerException("No pluginVersion was give to executeCommand()");
        }
        if (commandName == null) {
            logger.error((Object)"No commandName was given to executeCommand().");
            throw new NullPointerException("No commandName was give to executeCommand()");
        }
        if (commandName.length() == 0) {
            logger.error((Object)"Empty commandName was given to executeCommand().");
            throw new NullPointerException("Empty commandName was give to executeCommand()");
        }
        if (inputPropFile == null) {
            logger.error((Object)"No inputPropsFile was given to executeCommand().");
            throw new NullPointerException("No inputPropsFile was give to executeCommand()");
        }
        if (envPropFile == null) {
            logger.error((Object)"No envPropsFile was given to executeCommand().");
            throw new NullPointerException("No envPropsFile was give to executeCommand()");
        }
        if (outputPropFile == null) {
            logger.error((Object)"No outputPropFile was given to executeCommand().");
            throw new NullPointerException("No outputPropFile was give to executeCommand()");
        }
        if (this.impToken == null && !workingDirectory.isDirectory()) {
            throw new IOException("Working directory '" + workingDirectory.getAbsolutePath() + "' could not be found.");
        }
    }

    private void createAndValidateLogFiles(File outputLogFile, File errorLogFile) throws IOException {
        outputLogFile.createNewFile();
        errorLogFile.createNewFile();
        if (!outputLogFile.canWrite()) {
            throw new IOException("Log file '" + outputLogFile.getAbsolutePath() + "' is not writable.");
        }
        if (!errorLogFile.canWrite()) {
            throw new IOException("Log file '" + errorLogFile.getAbsolutePath() + "' is not writable.");
        }
    }

    private AutomationPlugin loadPluginWithCommand(File pluginHomeDirectory, String commandName) throws Exception {
        AutomationPlugin automationPlugin = this.loadPlugin(pluginHomeDirectory);
        if (automationPlugin == null) {
            throw new AutomationPluginRuntimeException("Could not load the Plugin from '" + pluginHomeDirectory + "'.");
        }
        if (!automationPlugin.hasCommand(commandName)) {
            throw new RuntimeException("Could not find Command '" + commandName + "' configured in" + " AutomationPlugin '" + automationPlugin.getId() + "'.");
        }
        return automationPlugin;
    }

    private void resolvePropertiesAndSetupCommandArgs(File inputPropFile, File outputPropFile, Set<String> propertyNamesToKeepEnvVarsIn, PropertyValueScope commandPropertyScope, Properties envProps, File pluginHomeDirectory, CommandLine commandLine, Properties resolvedCommandProperties, List<String> commandArgsList, Properties resolvedEnvProps) throws Exception {
        PropertyValueScope environmentPropertyScope = new PropertyValueScope(envProps);
        environmentPropertyScope.setParent(new PropertyValueScope(System.getenv()));
        commandPropertyScope.setParent(environmentPropertyScope);
        commandPropertyScope.put(INPUT_PROPS_ARG, inputPropFile.getAbsolutePath());
        commandPropertyScope.put(OUTPUT_PROPS_ARG, outputPropFile.getAbsolutePath());
        PropertyResolver resolver = new PropertyResolver(commandPropertyScope);
        for (Map.Entry<Object, Object> entry : envProps.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            key = resolver.resolve(key);
            value = resolver.resolve(value);
            resolvedEnvProps.setProperty(key, value);
        }
        commandArgsList.add(resolver.resolve(commandLine.getProgram()));
        for (Arg arg : commandLine.getArgs()) {
            commandArgsList.add(this.resolveCommandLineArg(arg, resolver, pluginHomeDirectory));
        }
        Properties commandProperties = commandPropertyScope.getCurrentProperties();
        for (Map.Entry<Object, Object> entry : commandProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!propertyNamesToKeepEnvVarsIn.contains(key)) {
                value = resolver.resolve(value);
                resolvedCommandProperties.setProperty(key, value);
                continue;
            }
            resolvedCommandProperties.setProperty(key, value);
        }
    }

    private void outputRunDetails(File workingDirectory, AutomationPlugin automationPlugin, Properties resolvedEnvProps, List<String> commandArgsList, Properties resolvedCommandProperties, PrintStream redactingOutputPrinter) throws IOException {
        redactingOutputPrinter.println("================================================================================");
        redactingOutputPrinter.println("plugin: " + automationPlugin.getName() + ", id: " + automationPlugin.getId() + ", version: " + automationPlugin.getVersion());
        redactingOutputPrinter.println("plugin command: " + this.commandLineToString(commandArgsList));
        redactingOutputPrinter.println("working directory: " + workingDirectory.getCanonicalPath());
        redactingOutputPrinter.println("properties:\n" + this.propsToString(resolvedCommandProperties));
        redactingOutputPrinter.println("environment:\n" + this.propsToString(resolvedEnvProps));
        redactingOutputPrinter.println("================================================================================");
    }

    private void configureEnvironmentProperties(Properties envProps, File pluginHomeDirectory) {
        String proxyPort;
        String proxyHost;
        envProps.put("PLUGIN_HOME", pluginHomeDirectory.getAbsolutePath());
        String systemEncoding = System.getProperty("system.default.encoding", "UTF-8");
        envProps.put("DS_SYSTEM_ENCODING", systemEncoding);
        String agentHome = System.getenv().get("AGENT_HOME");
        if (agentHome != null) {
            envProps.put("AGENT_HOME", agentHome);
        }
        if (this.opts != null) {
            String javaOpts = this.opts.getJavaOpts();
            if (javaOpts == null) {
                envProps.remove("JAVA_OPTS");
            } else {
                envProps.put("JAVA_OPTS", javaOpts);
            }
        }
        if (!StringUtil.isEmpty((String)(proxyHost = System.getProperty("http.proxyHost")))) {
            envProps.put("PROXY_HOST", proxyHost);
        }
        if (!StringUtil.isEmpty((String)(proxyPort = System.getProperty("http.proxyPort")))) {
            envProps.put("PROXY_PORT", proxyPort);
        }
        String codestationUrl = System.getProperty("codestation.url");
        boolean codestationUseProxy = Boolean.getBoolean("codestation.useProxy");
        if (codestationUrl == null && !StringUtil.isEmpty((String)proxyHost) && !StringUtil.isEmpty((String)proxyPort)) {
            boolean secure = Boolean.valueOf(System.getProperty("codestation.secure", "true"));
            try {
                int port = Integer.parseInt(proxyPort);
                ++port;
                String proto = "https";
                if (!secure) {
                    proto = "http";
                }
                codestationUrl = proto + "://" + proxyHost + ":" + port;
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Cannot set codestation URL: cannot parse proxy port: " + proxyPort), (Throwable)e);
            }
        }
        if (codestationUrl != null) {
            envProps.put("CODESTATION_URL", codestationUrl);
            envProps.put("CODESTATION_USE_PROXY", String.valueOf(codestationUseProxy));
        }
    }

    private void setupFetcher(Properties envProps) {
        Fetcher fetcher = this.cacheManager.getFetcher();
        if (fetcher instanceof FetcherHttp) {
            String webUrl = envProps.containsKey("WEB_URL") ? envProps.getProperty("WEB_URL") : envProps.getProperty("AH_WEB_URL");
            HttpConnectionSettings httpConn = new HttpConnectionSettings(webUrl);
            ((FetcherHttp)fetcher).setHttpConnectionSettings(httpConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePropertiesFile(File inputPropFile, Properties resolvedCommandProperties, SecretContainer secret) {
        FileOutputStream inputPropertiesStream;
        block8: {
            inputPropertiesStream = null;
            try {
                inputPropertiesStream = this.fileFactory.outputStream(inputPropFile);
                if (secret == null) {
                    resolvedCommandProperties.store(inputPropertiesStream, "Resolved Props");
                    break block8;
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    resolvedCommandProperties.store(os, "Resolved Props");
                    SecureBlob blob = SecureBlob.fromUnencryptedBytes((SecretContainer)secret, (byte[])os.toByteArray());
                    ((OutputStream)inputPropertiesStream).write(blob.getEncryptedBytes());
                }
                finally {
                    IO.close((OutputStream)os);
                }
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Couldn't write properties file for plugin.", e);
                }
                catch (Throwable throwable) {
                    IO.close(inputPropertiesStream);
                    throw throwable;
                }
            }
        }
        IO.close((OutputStream)inputPropertiesStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File inputPropFile, SecretContainer secret) throws FileNotFoundException, IOException, BadEnvelopeException, GeneralSecurityException {
        Properties inputProps = new Properties();
        FileInputStream inputPropsStream = null;
        if (inputPropFile.exists() && inputPropFile.length() > 0L) {
            block4: {
                try {
                    inputPropsStream = new FileInputStream(inputPropFile);
                    if (secret == null) {
                        inputProps.load(inputPropsStream);
                        break block4;
                    }
                    SecureBlob blob = SecureBlob.fromEncryptedBytes((SecretContainer)secret, (byte[])IO.read((InputStream)inputPropsStream));
                    inputProps.load(new ByteArrayInputStream(blob.get()));
                }
                catch (Throwable throwable) {
                    IO.close(inputPropsStream);
                    throw throwable;
                }
            }
            IO.close((InputStream)inputPropsStream);
        }
        return inputProps;
    }

    private void addEnvironmentProperties(PropertyValueScope commandPropertyScope, Properties envProps, Command command, SecretContainer secret) throws SecretUnavailableException {
        for (String propertyWildcardString : command.getPropertyToEnvironmentList()) {
            Pattern p = WildcardToRegex.convert((String)propertyWildcardString);
            for (Map.Entry<Object, Object> entry : commandPropertyScope.getAllProperties().entrySet()) {
                String key = (String)entry.getKey();
                Matcher m = p.matcher(key);
                if (!m.matches()) continue;
                String value = (String)entry.getValue();
                envProps.put(key, value);
            }
        }
        if (secret != null) {
            envProps.put(UCD_ENCRYPT_PROPERTIES_ENV_VAR, "true");
        }
    }

    private void validateRequiredProperties(String commandName, PropertyValueScope commandPropertyScope, AutomationPlugin automationPlugin) throws AutomationPluginRuntimeException {
        try {
            RequiredPropertyValidator requiredPropValidator = new RequiredPropertyValidator(commandPropertyScope);
            requiredPropValidator.validate(automationPlugin.getRequiredProperties(commandName));
        }
        catch (PropertyValueMissingException e) {
            List<PluginCommandProperty> propsWithNoValue = e.getListOfPluginPropertiesWithNoValues();
            Iterator<PluginCommandProperty> iterator = propsWithNoValue.iterator();
            StringBuilder sb = new StringBuilder("Error executing Plugin Command. The following properties are required but have missing values: ");
            sb.append(iterator.next().getName());
            while (iterator.hasNext()) {
                sb.append(", ").append(iterator.next().getName());
            }
            throw new AutomationPluginRuntimeException(sb.toString());
        }
    }

    private String commandLineToString(List<String> commandLine) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : commandLine) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append("'" + arg + "'");
        }
        return sb.toString();
    }

    private String propsToString(Properties properties) {
        ArrayList<String> envPropNames = new ArrayList<String>();
        for (Object key : properties.keySet()) {
            envPropNames.add(String.valueOf(key));
        }
        Collections.sort(envPropNames);
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String envPropName : envPropNames) {
            if (!first) {
                sb.append("\n");
            }
            sb.append("  ");
            first = false;
            sb.append(envPropName).append("=").append(properties.get(envPropName));
        }
        return sb.toString();
    }

    protected void preprocessCommandLineForOsSpecifics(OutputStream outputLogStream, OutputStream errorLogStream, Properties resolvedEnvProps, List<String> commandLine, File workingDirectory, ImpersonationToken impToken) throws Exception {
        File execFile;
        String executable = commandLine.get(0);
        if ("unix".equals(ShellHelper.getInstance().getOs()) && executable.startsWith(this.cacheManager.getBaseDir().getPath()) && (execFile = new File(executable)).isFile()) {
            LinkedList<String> chmodCommand = new LinkedList<String>();
            chmodCommand.add("chmod");
            chmodCommand.add("a+x");
            chmodCommand.add(executable);
            ShellHelper.getInstance().executeShellAndWait(outputLogStream, errorLogStream, resolvedEnvProps, chmodCommand, workingDirectory, impToken, new StepExecutionInfo(UUID.randomUUID()), null);
        }
        if ("windows".equals(ShellHelper.getInstance().getOs())) {
            String executableDotBatPath = executable + ".bat";
            File executableDotBat = new File(executableDotBatPath);
            if (executableDotBat.isFile()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Changing executable from " + executable + " to " + executableDotBatPath));
                }
                commandLine.set(0, executableDotBatPath);
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)".bat file didn't exist, not using");
            }
            String newCommand = CmdUtil.buildCommand(commandLine);
            commandLine.clear();
            commandLine.add("cmd");
            commandLine.add("/C");
            commandLine.add(newCommand);
        }
    }

    private AutomationPlugin loadPlugin(File pluginHomeDirectory) throws Exception {
        return new AutomationPlugin(pluginHomeDirectory, this.marshallingEngine);
    }

    private String resolveCommandLineArg(Arg arg, PropertyResolver resolver, File pluginHome) throws Exception {
        String result;
        String value = arg.getValue();
        switch (arg.getType()) {
            case VALUE: {
                result = resolver.resolve(arg.getValue());
                break;
            }
            case FILE: {
                result = this.convertFileArg(value, resolver, pluginHome);
                break;
            }
            case PATH: {
                result = this.convertPathArg(value, resolver, pluginHome);
                break;
            }
            default: {
                throw new Exception("Did not recognize command argument type '" + (Object)((Object)arg.getType()) + "'.");
            }
        }
        return result;
    }

    private String convertPathArg(String pathValue, PropertyResolver resolver, File pluginHome) {
        pathValue = resolver.resolve(pathValue);
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        boolean isDOS = File.pathSeparatorChar == ';';
        String[] parts = pathValue.split("[:;]+");
        for (int i = 0; i < parts.length; ++i) {
            String nextToken;
            String part = parts[i];
            if (part == null || part.length() == 0) continue;
            if (isDOS && part.length() == 1 && Character.isLetter(part.charAt(0)) && parts.length > i + 1 && ((nextToken = parts[i + 1]).startsWith("\\") || nextToken.startsWith("/"))) {
                ++i;
                part = part + ":" + nextToken;
            }
            paths.add(part);
        }
        String[] result = paths.toArray(new String[0]);
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.convertFileArg(result[i], resolver, pluginHome);
        }
        return StringUtil.join((String[])result, (String)File.pathSeparator);
    }

    private String convertFileArg(String fileValue, PropertyResolver resolver, File pluginHome) {
        fileValue = resolver.resolve(fileValue);
        File file = new File(fileValue = fileValue.replace('\\', File.separatorChar).replace('/', File.separatorChar));
        if (!file.isAbsolute()) {
            file = new File(pluginHome, fileValue);
        }
        return file.getAbsolutePath();
    }
}

