/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.Utils;
import com.urbancode.air.plugin_command.runtime.StepExecutionInfo;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.concurrent.WaitFuture;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.shell.Shell;
import com.urbancode.shell.impersonation.ImpersonationToken;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellHelper {
    private static final Logger logger = Logger.getLogger(ShellHelper.class);
    private static ShellHelper instance = new ShellHelper(null);
    private final String os;
    private final String arch;
    private final Charset decode;
    private final Map<StepExecutionInfo, Shell> procMap = new HashMap<StepExecutionInfo, Shell>();

    public static synchronized void setInstance(ShellHelper sh) {
        instance = sh;
    }

    public static synchronized ShellHelper getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ShellHelper not initalized.");
        }
        return instance;
    }

    public ShellHelper(Charset decode) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        this.os = osName.contains("windows") ? "windows" : (osName.contains("vms") ? "vms" : (osName.contains("mac") && !osName.endsWith("x") ? "os9" : (new Unix().isUnix() ? "unix" : "unknown")));
        this.arch = Utils.getArch();
        this.decode = decode;
    }

    public String getOs() {
        return this.os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(StepExecutionInfo info) {
        Map<StepExecutionInfo, Shell> map = this.procMap;
        synchronized (map) {
            Shell proc = this.procMap.remove(info);
            if (proc != null) {
                try {
                    proc.killProcess();
                }
                catch (Exception e) {
                    logger.error((Object)"Exception trying to kill process", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process executeShellAndWait(OutputStream outputStream, OutputStream errorStream, Properties environmentProperties, List<String> command, File workingDirectory, ImpersonationToken impToken, StepExecutionInfo info, Properties stdInProps) throws Exception {
        String verifyServerIdentityString;
        Object value;
        Object key;
        Shell shell = new Shell(command);
        if (impToken != null) {
            logger.debug((Object)("Using user : " + impToken.getUser()));
            logger.debug((Object)("Using group : " + impToken.getGroup()));
            logger.debug((Object)("Using sudo : " + impToken.isUseSudo()));
            shell.setImpersonationToken(impToken);
        }
        logger.debug((Object)("Setting working directory to: " + workingDirectory.getPath()));
        shell.setWorkingDirectory(workingDirectory);
        for (Map.Entry<Object, Object> entry : environmentProperties.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            shell.addEnvironmentVariable((String)key, (String)value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("verify.server.identity set to: " + System.getProperty("verify.server.identity")));
        }
        if ((verifyServerIdentityString = System.getProperty("verify.server.identity")) != null) {
            shell.addEnvironmentVariable("UC_TLS_VERIFY_CERTS", verifyServerIdentityString);
        }
        if (this.os.contains("windows") && System.getProperty("com.urbancode.winapi.WinAPI.dllPath") == null) {
            File libraryPath = new File(".." + File.separator + "native" + File.separator + this.arch + File.separator + "WinAPI.dll").getAbsoluteFile();
            if (!libraryPath.isFile()) {
                throw new IOException("Could not find native architecture libraries at '" + libraryPath + "'.");
            }
            System.setProperty("com.urbancode.winapi.WinAPI.dllPath", libraryPath.getAbsolutePath());
        }
        Process externalProc = null;
        key = info;
        synchronized (key) {
            if (!info.isAborted()) {
                logger.debug((Object)("Executing command: " + Arrays.toString(shell.getCommandLine().toStringArray())));
                shell.execute();
                externalProc = shell.getProcess();
                value = this.procMap;
                synchronized (value) {
                    this.procMap.put(info, shell);
                }
            }
        }
        if (externalProc != null) {
            Processes procUtils = new Processes();
            OutputStream output = outputStream;
            OutputStream error = errorStream;
            if (this.decode != null) {
                output = IO.transcode((Charset)this.decode, (Charset)IO.utf8(), (OutputStream)outputStream);
                error = IO.transcode((Charset)this.decode, (Charset)IO.utf8(), (OutputStream)errorStream);
            }
            WaitFuture outputFuture = procUtils.redirectOutput(externalProc, output);
            WaitFuture errorFuture = procUtils.redirectError(externalProc, error);
            OutputStream procStdIn = externalProc.getOutputStream();
            if (stdInProps != null && stdInProps.size() > 0) {
                stdInProps.store(procStdIn, "");
            }
            procStdIn.close();
            outputFuture.get();
            errorFuture.get();
            externalProc.waitFor();
            Map<StepExecutionInfo, Shell> map = this.procMap;
            synchronized (map) {
                this.procMap.remove(info);
            }
        }
        return externalProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmodDirectory(File dir, String permission) {
        if ("unix".equals(ShellHelper.getInstance().getOs())) {
            LinkedList<String> chmodCommand = new LinkedList<String>();
            chmodCommand.add("chmod");
            chmodCommand.add("-R");
            chmodCommand.add("a+" + permission);
            chmodCommand.add(dir.getAbsolutePath());
            ByteArrayOutputStream outputLogStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorLogStream = new ByteArrayOutputStream();
            Properties resolvedEnvProps = new Properties();
            File workingDirectory = new File(".");
            try {
                ShellHelper.getInstance().executeShellAndWait(outputLogStream, errorLogStream, resolvedEnvProps, chmodCommand, workingDirectory, null, new StepExecutionInfo(UUID.randomUUID()), null);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to chmod plugin directory!", (Throwable)e);
            }
            finally {
                IO.close((OutputStream)outputLogStream);
                IO.close((OutputStream)errorLogStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmodFile(File dir, String permission) {
        if ("unix".equals(ShellHelper.getInstance().getOs())) {
            LinkedList<String> chmodCommand = new LinkedList<String>();
            chmodCommand.add("chmod");
            chmodCommand.add(permission);
            chmodCommand.add(dir.getAbsolutePath());
            ByteArrayOutputStream outputLogStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorLogStream = new ByteArrayOutputStream();
            Properties resolvedEnvProps = new Properties();
            File workingDirectory = new File(".");
            try {
                ShellHelper.getInstance().executeShellAndWait(outputLogStream, errorLogStream, resolvedEnvProps, chmodCommand, workingDirectory, null, new StepExecutionInfo(UUID.randomUUID()), null);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to chmod file!", (Throwable)e);
            }
            finally {
                IO.close((OutputStream)outputLogStream);
                IO.close((OutputStream)errorLogStream);
            }
        }
    }
}

