/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.immutable.IImmutableList;
import com.urbancode.commons.util.immutable.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class ImmutableList<T>
implements IImmutableList<T> {
    int hash = -1;
    private final T first;
    private final ImmutableList<T> rest;
    private final int size;
    private static final ImmutableList<?> EMPTY = new ImmutableList();

    public static <T> ImmutableList<T> empty() {
        return EMPTY;
    }

    ImmutableList() {
        this.first = null;
        this.rest = null;
        this.size = 0;
    }

    ImmutableList(T first) {
        this.first = first;
        this.rest = null;
        this.size = 1;
    }

    ImmutableList(T _first, ImmutableList<T> _rest, int _count) {
        this.first = _first;
        this.rest = _rest;
        this.size = _count;
    }

    public static <T> ImmutableList<T> create(List<? extends T> init) {
        IImmutableList<T> ret = ImmutableList.empty();
        ListIterator<T> i = init.listIterator(init.size());
        while (i.hasPrevious()) {
            ret = ret.with((Object)i.previous());
        }
        return ret;
    }

    public static <T> ImmutableList<T> create(T ... init) {
        IImmutableList<T> ret = ImmutableList.empty();
        for (int i = init.length - 1; i >= 0; --i) {
            ret = ret.with((Object)init[i]);
        }
        return ret;
    }

    public String toString() {
        return Util.toString(this, this.iterator());
    }

    @Override
    public int hashCode() {
        if (this.hash == -1) {
            this.hash = Util.hashCode(this);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object object) {
        return Util.equals(this, object);
    }

    @Override
    public T first() {
        return this.first;
    }

    @Override
    public ImmutableList<T> rest() {
        if (this.size == 1) {
            return null;
        }
        return this.rest;
    }

    @Override
    public T peek() {
        return this.first();
    }

    @Override
    public ImmutableList<T> pop() {
        if (this.rest == null) {
            return ImmutableList.empty();
        }
        return this.rest;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableList<T> with(T o) {
        return new ImmutableList<T>(o, this, this.size + 1);
    }

    @Override
    public boolean contains(Object o) {
        for (IImmutableList<T> s = this; s != null; s = s.rest()) {
            if (!Util.equals(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableListIterator(this);
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return Util.toArray(this.size(), this.iterator(), array);
    }

    @Override
    public Object[] toArray() {
        return Util.toArray(this.size(), this.iterator());
    }

    @Override
    public int indexOf(Object o) {
        IImmutableList<T> s = this;
        int i = 0;
        while (s != null) {
            if (Util.equals(s.first(), o)) {
                return i;
            }
            s = s.rest();
            ++i;
        }
        return -1;
    }

    @Override
    public T get(int index) {
        IImmutableList<T> seq = this;
        int i = 0;
        while (i <= index) {
            if (i == index) {
                return this.first();
            }
            ++i;
            seq = seq.rest();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ImmutableList<T> subList(int fromIndex, int toIndex) {
        int i;
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<T> accum = new ArrayList<T>();
        IImmutableList<T> seq = this;
        for (i = 0; seq != null && i < fromIndex; seq = ((ImmutableList)seq).rest(), ++i) {
        }
        while (seq != null && i < toIndex) {
            accum.add(((ImmutableList)seq).first());
            ++i;
            seq = ((ImmutableList)seq).rest();
        }
        return ImmutableList.create(accum);
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.reify().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.reify().listIterator(index);
    }

    private List<T> reify() {
        return Collections.unmodifiableList(new ArrayList(this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    private static final class ImmutableListIterator<T>
    implements Iterator<T> {
        IImmutableList<T> list;

        public ImmutableListIterator(IImmutableList<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.list != null;
        }

        @Override
        public T next() {
            if (this.list == null) {
                throw new NoSuchElementException();
            }
            T ret = this.list.first();
            this.list = this.list.rest();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

