/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction;

import com.urbancode.air.plugin_command.redaction.AbstractACRedactorBuilder;
import com.urbancode.air.plugin_command.redaction.ByteString;
import com.urbancode.air.plugin_command.redaction.trie.Emit;
import com.urbancode.air.plugin_command.redaction.trie.EmitHandler;
import com.urbancode.air.plugin_command.redaction.trie.Trie;
import com.urbancode.commons.util.IO;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ACRedactingOutputStream
extends FilterOutputStream {
    private static final int BLANK = -1;
    private static final int REDACT = -2;
    private final Trie.Parser parser;
    private final byte[] redactToken;
    private final int[] redactBuf;
    private final int redactBufRollMask;
    private int redactBufWritePos;
    private boolean redacting;

    public static Builder builder() {
        return new Builder(IO.utf8());
    }

    public static Builder builder(Charset charset) {
        return new Builder(charset);
    }

    ACRedactingOutputStream(Trie trie, OutputStream out, byte[] redactToken) {
        super(out);
        out.getClass();
        redactToken.getClass();
        this.redactToken = redactToken;
        this.parser = trie.createParser(this.getEmitHandler());
        this.redactBuf = new int[this.nextHighestPowerOf2(trie.getMaxKeywordLength())];
        this.redactBufRollMask = this.redactBuf.length - 1;
        Arrays.fill(this.redactBuf, -1);
    }

    public void write(int b) throws IOException {
        b &= 0xFF;
        if (this.redactBuf.length != 0) {
            this.write0(this.redactBuf[this.redactBufWritePos]);
            this.redactBuf[this.redactBufWritePos] = b;
            this.redactBufWritePos = this.advanceRedactBufIndex(this.redactBufWritePos);
        } else {
            this.write0(b);
        }
        this.parser.parse(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.finishWrite();
        }
        finally {
            super.close();
        }
    }

    private EmitHandler getEmitHandler() {
        return new EmitHandler(){

            public boolean emit(Emit emit) {
                ACRedactingOutputStream.this.redact(emit);
                return false;
            }
        };
    }

    private void redact(Emit emit) {
        int p = this.redactBufWritePos - 1;
        for (int i = 0; i < emit.getKeyword().length(); ++i) {
            if (p < 0) {
                p = this.redactBuf.length - 1;
            }
            this.redactBuf[p] = -2;
            --p;
        }
    }

    private void write0(int b) throws IOException {
        if (b == -1) {
            return;
        }
        if (b == -2) {
            if (this.redacting) {
                return;
            }
            this.redacting = true;
            return;
        }
        this.endRedact();
        try {
            this.out.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void endRedact() throws IOException {
        if (this.redacting) {
            this.redacting = false;
            this.out.write((byte[])this.redactToken.clone());
        }
    }

    private void finishWrite() throws IOException {
        int p = this.redactBufWritePos;
        int n = this.redactBuf.length;
        for (int i = 0; i < n; ++i) {
            int c = this.redactBuf[p];
            this.write0(c);
            p = this.advanceRedactBufIndex(p);
        }
        this.endRedact();
    }

    private int advanceRedactBufIndex(int p) {
        return p + 1 & this.redactBufRollMask;
    }

    private int nextHighestPowerOf2(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends AbstractACRedactorBuilder<Builder> {
        private final Charset charset;

        Builder(Charset charset) {
            charset.getClass();
            this.charset = charset;
        }

        public ACRedactingOutputStream build(OutputStream out) {
            return new ACRedactingOutputStream(this.buildTrie(), out, this.redactToken.getBytes(this.charset));
        }

        @Override
        protected void addSecret(Trie.TrieBuilder builder, String secret) {
            builder.addKeyword(new ByteString(-1, secret.getBytes(this.charset)));
        }
    }
}

