/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction.trie;

import com.urbancode.air.plugin_command.redaction.ByteString;
import com.urbancode.air.plugin_command.redaction.trie.Emit;
import com.urbancode.air.plugin_command.redaction.trie.EmitHandler;
import com.urbancode.air.plugin_command.redaction.trie.State;
import java.util.LinkedList;

public final class Trie {
    public final State rootState = new State();
    private int maxKeywordLength;

    private Trie() {
    }

    private void addKeyword(ByteString keyword) {
        if (keyword.length() == 0) {
            return;
        }
        this.maxKeywordLength = Math.max(this.maxKeywordLength, keyword.length());
        this.addState(keyword).addEmit(keyword);
    }

    private State addState(ByteString keyword) {
        return this.getRootState().addState(keyword);
    }

    public int getMaxKeywordLength() {
        return this.maxKeywordLength;
    }

    public Parser createParser(EmitHandler emitHandler) {
        return new Parser(emitHandler);
    }

    private State getState(State currentState, byte character) {
        State newCurrentState = currentState.nextState(character);
        while (newCurrentState == null) {
            currentState = currentState.failure();
            newCurrentState = currentState.nextState(character);
        }
        return newCurrentState;
    }

    private void constructFailureStates() {
        LinkedList<State> queue = new LinkedList<State>();
        State startState = this.getRootState();
        for (State depthOneState : startState.getSuccessStates()) {
            if (depthOneState == null) continue;
            queue.add(depthOneState);
            depthOneState.setFailure(startState);
        }
        while (!queue.isEmpty()) {
            State currentState = (State)queue.remove();
            State[] states = currentState.getSuccessStates();
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == null) continue;
                byte transition = (byte)(i + currentState.getSuccessStatesOffset());
                State targetState = currentState.nextState(transition);
                queue.add(targetState);
                State traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                State newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState);
                targetState.addEmitArray(newFailureState.emits());
            }
        }
    }

    private boolean storeEmits(long position, State currentState, EmitHandler emitHandler) {
        boolean emitted = false;
        ByteString[] emits = currentState.emits();
        if (emits != null) {
            for (ByteString emit : emits) {
                emitHandler.emit(new Emit(position - (long)emit.length() + 1L, position, emit));
            }
        }
        return emitted;
    }

    private State getRootState() {
        return this.rootState;
    }

    public static TrieBuilder builder() {
        return new TrieBuilder();
    }

    public static class TrieBuilder {
        private final Trie trie = new Trie();

        private TrieBuilder() {
        }

        public TrieBuilder addKeyword(String keyword) {
            this.trie.addKeyword(new ByteString(keyword));
            return this;
        }

        public TrieBuilder addKeyword(ByteString keyword) {
            this.trie.addKeyword(keyword);
            return this;
        }

        public Trie build() {
            this.trie.constructFailureStates();
            return this.trie;
        }
    }

    public class Parser {
        final EmitHandler emitHandler;
        State currentState;
        long position;

        Parser(EmitHandler emitHandler) {
            this.currentState = Trie.this.getRootState();
            this.emitHandler = emitHandler;
        }

        public void parse(int b) {
            this.currentState = Trie.this.getState(this.currentState, (byte)b);
            Trie.this.storeEmits(this.position, this.currentState, this.emitHandler);
            ++this.position;
        }
    }
}

