/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper


final def props = new Properties()
final def inputPropsFile = new File(args[0])
final def inputPropsStream = null
try {
    inputPropsStream = new FileInputStream(inputPropsFile)
    props.load(inputPropsStream)
}
catch (IOException e) {
    throw new RuntimeException(e)
}

final def group = props['group']
final def users = props['users'].split('\n')

def ch = new CommandHelper(new File('.'))
def argsGroupAdd = ['groupadd', group]

ch.runCommand(argsGroupAdd.join(' '), argsGroupAdd)

users.each {
    def argsUserMod = ['usermod', '-a', '-G', group, it]
    ch.runCommand(argsUserMod.join(' '), argsUserMod)
}