/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.postprocess;

import com.urbancode.commons.sandboxedjsruntime.SandboxedJSRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    private File output;
    private SandboxedJSRuntime rt;
    private List<RegexScriptPair> regexScriptList = new ArrayList<RegexScriptPair>();
    private List<Integer> linesOfInterest = new ArrayList<Integer>();

    public void addLOI(Integer line) {
        if (!this.linesOfInterest.contains(line)) {
            this.linesOfInterest.add(line);
        }
    }

    public List<Integer> getLinesOfInterest() {
        return this.linesOfInterest;
    }

    public Scanner(File output, SandboxedJSRuntime rt) {
        this.rt = rt;
        this.output = output;
    }

    public void register(String regex, Function script) {
        this.regexScriptList.add(new RegexScriptPair(regex, script));
    }

    public void scan() {
        String matchString = "";
        boolean first = true;
        for (RegexScriptPair pair : this.regexScriptList.toArray(new RegexScriptPair[0])) {
            if (first) {
                matchString = matchString + "(" + pair.getRegex() + ")";
                first = false;
                continue;
            }
            matchString = matchString + "|(" + pair.getRegex() + ")";
        }
        Pattern pattern = Pattern.compile(matchString);
        BufferedReader input = null;
        try {
            input = new LineNumberReader(new FileReader(this.output));
            String line = null;
            while ((line = ((LineNumberReader)input).readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                boolean matched = false;
                while (matcher.find()) {
                    if (!matched) {
                        this.addLOI(((LineNumberReader)input).getLineNumber());
                    }
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        if (matcher.group(i) == null) continue;
                        Function fn = this.regexScriptList.get(i - 1).getScript();
                        this.rt.callFunction(fn, null, new Object[]{((LineNumberReader)input).getLineNumber(), line});
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException running post processing script!");
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private class RegexScriptPair {
        String regex;
        Function script;

        public RegexScriptPair(String regex, Function script) {
            this.regex = regex;
            this.script = script;
        }

        public Function getScript() {
            return this.script;
        }

        public String getRegex() {
            return this.regex;
        }
    }
}

