/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.properties;

import com.urbancode.air.plugin_command.Extensible;
import com.urbancode.air.plugin_command.Extension;
import com.urbancode.air.plugin_command.properties.SelectValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginCommandProperty
implements Extensible {
    private String name;
    private boolean required;
    private List<SelectValue> allowedValues;
    private Extension extension;

    public PluginCommandProperty(String name, boolean required, List<SelectValue> allowedValues) {
        this.name = name;
        this.required = required;
        this.allowedValues = allowedValues;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void addAllowedValue(SelectValue value) {
        if (this.allowedValues == null) {
            this.allowedValues = new ArrayList<SelectValue>();
        }
        if (!this.allowedValues.contains(value)) {
            this.allowedValues.add(value);
        }
    }

    public List<SelectValue> getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public Extension getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public String toString() {
        return "PluginProperty(" + this.name + ", " + this.required + ")";
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public boolean apiEquals(PluginCommandProperty that) {
        boolean result;
        boolean bl = result = this.isRequired() == that.isRequired();
        if (that.allowedValues == null && this.allowedValues != null || that.allowedValues != null && this.allowedValues == null) {
            result = false;
        }
        if (result && that.allowedValues != null && this.allowedValues != null) {
            HashSet<String> thisValues = new HashSet<String>();
            for (SelectValue val : this.allowedValues) {
                thisValues.add(val.getValue());
            }
            HashSet<String> thatValues = new HashSet<String>();
            for (SelectValue val : that.allowedValues) {
                thatValues.add(val.getValue());
            }
            result = thisValues.equals(thatValues);
        }
        if (result && this.extension != null) {
            result = this.extension.apiEquals(that.extension);
        }
        return result;
    }
}

