/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.redaction;

import com.urbancode.air.plugin_command.redaction.Redactor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedactingPrintStream
extends PrintStream {
    private final Redactor redactor = new Redactor();
    private final Set<String> secureValues;
    private int maxSecureLength = 0;
    private byte[] prevBuffer = null;
    private int prevOffset;
    private int prevLength;

    public RedactingPrintStream(PrintStream core, Set<String> secureValues) {
        super(core);
        ArrayList<String> sortedValues = new ArrayList<String>();
        if (secureValues != null) {
            sortedValues.addAll(secureValues);
        }
        Collections.sort(sortedValues, new StringLengthComparator());
        this.secureValues = new LinkedHashSet<String>();
        this.secureValues.addAll(sortedValues);
        this.secureValues.remove(null);
        for (String secure : this.secureValues) {
            this.maxSecureLength = Math.max(this.maxSecureLength, secure.length());
        }
    }

    @Override
    public void print(String s) {
        if (this.secureValues.isEmpty()) {
            super.print(s);
        } else {
            super.print(this.redactor.redact(this.getSecureValues(), s));
        }
    }

    @Override
    public void println(String s) {
        if (this.secureValues.isEmpty()) {
            super.println(s);
        } else {
            super.println(this.redactor.redact(this.getSecureValues(), s));
        }
    }

    protected Set<String> getSecureValues() {
        return this.secureValues;
    }

    private byte[] redact(byte[] nextBuffer) {
        String currentString = this.prevBuffer != null ? new String(this.prevBuffer) : "";
        String nextString = new String(nextBuffer);
        boolean isSingleLine = true;
        if (nextBuffer.length > 0) {
            isSingleLine = nextBuffer[nextBuffer.length - 1] == 10 || nextBuffer[nextBuffer.length - 1] == 13;
        }
        boolean endsWithSecure = false;
        for (String secure : this.secureValues) {
            if (!nextString.endsWith(secure)) continue;
            endsWithSecure = true;
            break;
        }
        if (endsWithSecure || isSingleLine) {
            currentString = currentString + nextString;
            nextString = "";
        } else {
            String testLine = currentString;
            boolean found = false;
            for (int i = 0; i < this.maxSecureLength - 1 && i < nextString.length(); ++i) {
                testLine = testLine + nextString.charAt(i);
                for (String secure : this.secureValues) {
                    if (!testLine.endsWith(secure)) continue;
                    currentString = testLine;
                    nextString = i + 1 < nextString.length() ? nextString.substring(i + 1) : "";
                    found = true;
                    break;
                }
                if (found) break;
            }
        }
        this.prevBuffer = nextString.getBytes();
        currentString = this.redactor.redact(this.secureValues, currentString);
        return currentString.getBytes();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        if (this.secureValues.isEmpty()) {
            super.write(buffer, offset, length);
        } else {
            byte[] segment = new byte[length];
            System.arraycopy(buffer, offset, segment, 0, length);
            segment = this.redact(segment);
            if (segment != null) {
                super.write(segment, 0, segment.length);
            }
        }
    }

    @Override
    public void close() {
        if (this.prevBuffer != null) {
            this.write(this.prevBuffer, this.prevOffset, this.prevLength);
        }
        super.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringLengthComparator
    implements Comparator<String> {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String string1, String string2) {
            return string2.length() - string1.length();
        }
    }
}

