/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command;

import com.urbancode.air.plugin_command.Command;
import com.urbancode.air.plugin_command.Extensible;
import com.urbancode.air.plugin_command.Extension;
import com.urbancode.air.plugin_command.Utils;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.air.plugin_command.validation.PluginCommandValidator;
import com.urbancode.commons.xml.marshall.MarshallingContext;
import com.urbancode.commons.xml.marshall.MarshallingEngine;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationPlugin
implements Extensible {
    private static final Logger logger = Logger.getLogger(AutomationPlugin.class);
    private static final String PLUGIN_XML_NAME = "plugin.xml";
    private static final String PLUGIN_INFO_XML_NAME = "info.xml";
    private static final String PLUGIN_EXTENSIONS_XML_NAME = "plugin-extensions.xml";
    private static final String PLUGIN_EXTENSIONS_TAG = "plugin-extensions";
    private static final String REQUIRE_ENCRYPTION_TAG = "require-property-file-encryption";
    private static final String RELEASE_VERSION_TAG = "release-version";
    private String id;
    private String name;
    private long version;
    private String release;
    private String description;
    private String tag;
    private String requiredServerVersion;
    private boolean requirePropertyEncryption = false;
    private Map<String, Command> commands = new HashMap<String, Command>();
    private Extension extension;

    public AutomationPlugin(File homeDirectory, MarshallingEngine eng) {
        try {
            this.loadPluginFromHomeDirectory(homeDirectory, eng);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Invalid plugin in directory " + homeDirectory.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid plugin in directory " + homeDirectory.getAbsolutePath(), e);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid plugin in directory " + homeDirectory.getAbsolutePath(), e);
        }
        catch (DOMException e) {
            throw new IllegalArgumentException("Invalid plugin in directory " + homeDirectory.getAbsolutePath(), e);
        }
        catch (SchemaValidationException e) {
            throw new IllegalArgumentException("Invalid plugin in directory " + homeDirectory.getAbsolutePath(), e);
        }
    }

    private void loadPluginFromHomeDirectory(File pluginHomeDirectory, MarshallingEngine marshallingEngine) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, DOMException, SchemaValidationException {
        File infoFile;
        DocumentBuilder builder;
        Document extDoc;
        Element rootElem;
        logger.debug((Object)("AutomationPlugin home directory: " + pluginHomeDirectory.getPath()));
        File configFile = new File(pluginHomeDirectory, PLUGIN_XML_NAME);
        PluginCommandValidator validator = new PluginCommandValidator();
        Document doc = validator.validateAndTransform(configFile);
        MarshallingContext context = new MarshallingContext();
        context.push((Object)this);
        try {
            marshallingEngine.unmarshall(doc.getDocumentElement(), context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AutomationPlugin result = (AutomationPlugin)context.get();
        File extensionsFile = new File(pluginHomeDirectory, PLUGIN_EXTENSIONS_XML_NAME);
        if (extensionsFile.isFile() && (rootElem = (extDoc = (builder = DocumentBuilderFactory.newInstance().newDocumentBuilder()).parse(extensionsFile)).getDocumentElement()).getNodeName().equals(PLUGIN_EXTENSIONS_TAG)) {
            NodeList nodes = rootElem.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                if (1 != node.getNodeType() || !node.getNodeName().equals(REQUIRE_ENCRYPTION_TAG)) continue;
                result.setRequiresPropertyFileEncryption(true);
            }
        }
        if ((infoFile = new File(pluginHomeDirectory, PLUGIN_INFO_XML_NAME)).isFile()) {
            DocumentBuilder builder2 = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document extDoc2 = builder2.parse(infoFile);
            Element rootElem2 = extDoc2.getDocumentElement();
            NodeList nodes = rootElem2.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                if (1 != node.getNodeType() || !node.getNodeName().equals(RELEASE_VERSION_TAG)) continue;
                result.setRelease(node.getTextContent());
                break;
            }
        }
    }

    public AutomationPlugin(String id, String name, long version, String description, String tag) {
        this(id, name, version, description, tag, null);
    }

    public AutomationPlugin(String id, String name, long version, String description, String tag, String requiredServerVersion) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = Utils.removeDuplicateWhitespace(description).trim();
        this.tag = tag;
        this.requiredServerVersion = requiredServerVersion;
    }

    public Command getCommandByName(String name) {
        Command result = this.commands.get(name);
        return result;
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName(), command);
    }

    public Collection<Command> getCommands() {
        return this.commands.values();
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExecuteCommand(String commandName) {
        Command command = this.getCommandByName(commandName);
        return command.getExecuteCommand();
    }

    public String getPostProcessingScript(String commandName) {
        Command command = this.getCommandByName(commandName);
        return command.getPostProcessingScript();
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<PluginCommandProperty> getRequiredProperties(String commandName) {
        LinkedList<PluginCommandProperty> result = new LinkedList<PluginCommandProperty>();
        Command command = this.getCommandByName(commandName);
        for (PluginCommandProperty prop : command.getPluginProps()) {
            if (!prop.isRequired()) continue;
            result.add(prop);
        }
        return result;
    }

    public String getTag() {
        return this.tag;
    }

    public long getVersion() {
        return this.version;
    }

    public String getRelease() {
        return this.release;
    }

    @Override
    public Extension getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public String getRequiredServerVersion() {
        return this.requiredServerVersion;
    }

    public boolean hasCommand(String actionName) {
        return this.commands.containsKey(actionName);
    }

    public boolean requiresPropertyFileEncryption() {
        return this.requirePropertyEncryption;
    }

    public void setRequiresPropertyFileEncryption(boolean require) {
        this.requirePropertyEncryption = require;
    }

    public boolean apiEquals(AutomationPlugin that) {
        boolean result = this.id.equals(that.id);
        if (!result) {
            String oldThisId = this.id.replace(".air.", ".anthill3.");
            String oldThatId = that.id.replace(".air.", ".anthill3.");
            result = oldThisId.equals(oldThatId);
        }
        if (result && this.extension != null) {
            result = this.extension.apiEquals(that.extension);
        }
        if (result) {
            Set<String> thisCommandNames = this.commands.keySet();
            Set<String> thatCommandNames = that.commands.keySet();
            result = thatCommandNames.equals(thisCommandNames);
        }
        for (Command thisCom : this.commands.values()) {
            if (!result) break;
            String name = thisCom.getName();
            Command thatCom = that.commands.get(name);
            result = thisCom.apiEquals(thatCom);
        }
        return result;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }
}

