/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def group = props['group']
final def users = props['users'].split('\n')

def ch = new CommandHelper(new File('.'))
def argsGroupAdd = ['groupadd', group]

ch.runCommand(argsGroupAdd.join(' '), argsGroupAdd)

users.each {
    def argsUserMod = ['usermod', '-a', '-G', group, it]
    ch.runCommand(argsUserMod.join(' '), argsUserMod)
}