/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobilefirst.container;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class CommonRestCalls {
    public String getCtrStateWithName(String[] args) {
        String ContainerState = "NotAvailable";
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            String listContainerUrl = String.valueOf(args[1]) + "/containers/json?all=true";
            HttpGet request = new HttpGet(listContainerUrl);
            request.addHeader("Accept", "application/json");
            request.addHeader("X-Auth-Token", args[2]);
            request.addHeader("X-Auth-Project-Id", args[3]);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                if (temp != null && !temp.equals("[]")) {
                    JSONArray obj = JSONArray.parse((String)temp);
                    int i = 0;
                    while (i < obj.size()) {
                        JSONObject jsonObject = (JSONObject)obj.get(i);
                        String containerState = (String)jsonObject.get((Object)"ContainerState");
                        String name = (String)jsonObject.get((Object)"Name");
                        if (name != null && name.equals(args[4])) {
                            return containerState;
                        }
                        ++i;
                    }
                }
                return ContainerState;
            }
            return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase();
        }
        catch (Exception ex) {
            System.out.println("Error Occured in REST Call.");
            ex.printStackTrace();
            return "Error Occured in REST Call.";
        }
    }

    public String getNameSpace(String[] args) {
        String nameSpace = "";
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            String listContainerUrl = String.valueOf(args[1]) + "/registry/namespaces";
            HttpGet request = new HttpGet(listContainerUrl);
            request.addHeader("Accept", "application/json");
            request.addHeader("X-Auth-Token", args[2]);
            request.addHeader("X-Auth-Project-Id", args[3]);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                if (temp != null) {
                    JSONObject jsonObject = JSONObject.parse((String)temp);
                    nameSpace = (String)jsonObject.get((Object)"namespace");
                }
                return nameSpace;
            }
            return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase();
        }
        catch (Exception ex) {
            System.out.println("Error Occured in REST Call.");
            ex.printStackTrace();
            return "Error Occured in REST Call.";
        }
    }

    public String getCtrIdWithName(String[] args) {
        HttpResponse response;
        block6: {
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                String listContainerUrl = String.valueOf(args[1]) + "/containers/json?all=true";
                HttpGet request = new HttpGet(listContainerUrl);
                request.addHeader("Accept", "application/json");
                request.addHeader("X-Auth-Token", args[2]);
                request.addHeader("X-Auth-Project-Id", args[3]);
                response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) break block6;
                String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                if (temp != null && !temp.equals("[]")) {
                    JSONArray jsonArray = JSONArray.parse((String)temp);
                    int i = 0;
                    while (i < jsonArray.size()) {
                        JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                        String id = (String)jsonObject.get((Object)"Id");
                        String name = (String)jsonObject.get((Object)"Name");
                        if (name != null && name.equals(args[4])) {
                            return id;
                        }
                        ++i;
                    }
                }
                return "Error Occured in REST Call.";
            }
            catch (Exception ex) {
                System.out.println("Error Occured in REST Call.");
                ex.printStackTrace();
                return "Error Occured in REST Call.";
            }
        }
        return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase() + " " + CommonRestCalls.readResponseContent(response.getEntity().getContent());
    }

    public String getCtrGrpStateWithName(String[] args) {
        String ContainerGrpState = "";
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            String listContainerGrpUrl = String.valueOf(args[1]) + "/containers/groups/" + args[4];
            HttpGet request = new HttpGet(listContainerGrpUrl);
            request.addHeader("Accept", "application/json");
            request.addHeader("X-Auth-Token", args[2]);
            request.addHeader("X-Auth-Project-Id", args[3]);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                if (temp != null) {
                    JSONObject jsonObject = JSONObject.parse((String)temp);
                    ContainerGrpState = (String)jsonObject.get((Object)"Status");
                }
                return ContainerGrpState;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                return String.valueOf(response.getStatusLine().getStatusCode()) + " Reason - " + response.getStatusLine().getReasonPhrase();
            }
            return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase();
        }
        catch (Exception ex) {
            System.out.println("Error Occured in REST Call.");
            ex.printStackTrace();
            return "Error Occured in REST Call.";
        }
    }

    public String getCtrGrpIdWithName(String[] args) {
        HttpResponse response;
        block6: {
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                String listGrpContainerUrl = String.valueOf(args[1]) + "/containers/groups";
                HttpGet request = new HttpGet(listGrpContainerUrl);
                request.addHeader("Accept", "application/json");
                request.addHeader("X-Auth-Token", args[2]);
                request.addHeader("X-Auth-Project-Id", args[3]);
                response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) break block6;
                String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                if (temp != null && !temp.equals("[]")) {
                    JSONArray jsonArray = JSONArray.parse((String)temp);
                    int i = 0;
                    while (i < jsonArray.size()) {
                        JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                        String id = (String)jsonObject.get((Object)"Id");
                        String name = (String)jsonObject.get((Object)"Name");
                        if (name != null && name.equals(args[4])) {
                            return id;
                        }
                        ++i;
                    }
                }
                return "Error Occured in REST Call.";
            }
            catch (Exception ex) {
                System.out.println("Error Occured in REST Call.");
                ex.printStackTrace();
                return "Error Occured in REST Call.";
            }
        }
        return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase() + " " + CommonRestCalls.readResponseContent(response.getEntity().getContent());
    }

    public String inspectContainerGetState(String[] args) {
        HttpResponse response;
        block6: {
            String ContainerState = "NotAvailable";
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                String inspectContainerUrl = String.valueOf(args[1]) + "/containers/" + args[4] + "/json";
                HttpGet request = new HttpGet(inspectContainerUrl);
                request.addHeader("Accept", "application/json");
                request.addHeader("X-Auth-Token", args[2]);
                request.addHeader("X-Auth-Project-Id", args[3]);
                response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (temp != null && !temp.equals("[]")) {
                        JSONObject jsonObject = JSONObject.parse((String)temp);
                        String containerState = (String)jsonObject.get((Object)"ContainerState");
                        String id = (String)jsonObject.get((Object)"Id");
                        if (id != null && id.equals(args[4])) {
                            return containerState;
                        }
                    }
                    return ContainerState;
                }
                if (response.getStatusLine().getStatusCode() != 404) break block6;
                return "Container Not Found";
            }
            catch (Exception ex) {
                System.out.println("Error Occured in REST Call.");
                ex.printStackTrace();
                return "Error Occured in REST Call.";
            }
        }
        return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase();
    }

    public static String readResponseContent(InputStream rs) {
        String line = "";
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(rs));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getImageList(String[] args) {
        String ImageList;
        block4: {
            ImageList = "NotAvailable";
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                String listContainerUrl = String.valueOf(args[1]) + "/images/json";
                HttpGet request = new HttpGet(listContainerUrl);
                request.addHeader("Accept", "application/json");
                request.addHeader("X-Auth-Token", args[2]);
                request.addHeader("X-Auth-Project-Id", args[3]);
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase() + " " + CommonRestCalls.readResponseContent(response.getEntity().getContent());
                String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                if (temp == null || temp.equals("[]")) break block4;
                JSONArray jsonArray = JSONArray.parse((String)temp);
                int i = 0;
                while (i < jsonArray.size()) {
                    ++i;
                }
                return null;
            }
            catch (Exception ex) {
                System.out.println("Error Occured in REST Call.");
                ex.printStackTrace();
                return "Error Occured in REST Call.";
            }
        }
        return ImageList;
    }

    public String getVolumeList(String[] args) {
        String volumeList = "";
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            String listContainerUrl = String.valueOf(args[1]) + "/volumes/json";
            HttpGet request = new HttpGet(listContainerUrl);
            request.addHeader("Accept", "application/json");
            request.addHeader("X-Auth-Token", args[2]);
            request.addHeader("X-Auth-Project-Id", args[3]);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String temp = EntityUtils.toString((HttpEntity)response.getEntity());
                if (temp != null && !temp.equals("[]")) {
                    JSONArray jsonArray = JSONArray.parse((String)temp);
                    int i = 0;
                    while (i < jsonArray.size()) {
                        JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                        volumeList = i == 0 ? (String)jsonObject.get((Object)"volName") : String.valueOf(volumeList) + "," + (String)jsonObject.get((Object)"volName");
                        ++i;
                    }
                }
                return volumeList;
            }
            return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase() + " " + CommonRestCalls.readResponseContent(response.getEntity().getContent());
        }
        catch (Exception ex) {
            System.out.println("Error Occured in REST Call.");
            ex.printStackTrace();
            return "Error Occured in REST Call.";
        }
    }

    public String createVolume(String[] args) {
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            String listContainerUrl = String.valueOf(args[1]) + "/volumes/create?name=" + args[4];
            HttpPost request = new HttpPost(listContainerUrl);
            request.addHeader("Accept", "application/json");
            request.addHeader("X-Auth-Token", args[2]);
            request.addHeader("X-Auth-Project-Id", args[3]);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 201) {
                return Integer.toString(response.getStatusLine().getStatusCode());
            }
            return "Error Occured in REST Call. Status is " + response.getStatusLine().getStatusCode() + " Reason - " + response.getStatusLine().getReasonPhrase() + " " + CommonRestCalls.readResponseContent(response.getEntity().getContent());
        }
        catch (Exception ex) {
            System.out.println("Error Occured in REST Call.");
            ex.printStackTrace();
            return "Error Occured in REST Call.";
        }
    }
}

