#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash


#set -x
#main

echo "Arguments : "
echo "----------- "
echo 
echo "BLUEMIX_API_URL : " $BLUEMIX_API_URL
echo "BLUEMIX_CCS_HOST : " $BLUEMIX_CCS_HOST
echo "BLUEMIX_USER : " $BLUEMIX_USER
echo "BLUEMIX_PASSWORD : " $BLUEMIX_PASSWORD
echo "BLUEMIX_ORG : " $BLUEMIX_ORG
echo "BLUEMIX_SPACE : " $BLUEMIX_SPACE
echo 

echo "Logging into IBM Bluemix Container Cloud Service.."
export CLASSPATH="$PLUGIN_HOME/java/containerRESTCall.jar:$PLUGIN_HOME/lib/JSON4J.jar:$PLUGIN_HOME/lib/log4j-1.2.17.jar:$PLUGIN_HOME/lib/httpmime-4.5.jar:$PLUGIN_HOME/lib/commons-codec-1.9.jar:$PLUGIN_HOME/lib/commons-logging-1.2.jar:$PLUGIN_HOME/lib/httpclient-4.5.jar:$PLUGIN_HOME/lib/httpcore-4.4.1.jar"

auth_info_url="$BLUEMIX_API_URL/v2/info"
echo "auth_info_url is $auth_info_url"
auth_endpoint=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'retrieveAuthEndpointURL' "$BLUEMIX_API_URL/v2/info")
echo "authEndpoint in script is $auth_endpoint"
if  [[ $auth_endpoint == Error* ]]  ; then
	echo "Error Occured in auth end point retrieval - Quitting!"		
	exit 1
fi

uaa_endpoint="$auth_endpoint/oauth/token"
echo "uaa_endpoint is $uaa_endpoint"
access_token=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'login' "$auth_endpoint/oauth/token" 'password' $BLUEMIX_USER $BLUEMIX_PASSWORD)
echo "access_token in script is $access_token"
if  [[ $access_token == Error* ]]  ; then
	echo "Error Occured in access token retrieval - Quitting!"		
	exit 1
fi

spaceGUID=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'getSpaceGUID' "$BLUEMIX_API_URL/v2/spaces" $access_token $BLUEMIX_SPACE)
echo "spaceGUID in script is $spaceGUID"
if  [[ $spaceGUID == Error* ]]  ; then
	echo "Error Occured in space guid retrieval - Quitting!"		
	exit 1
fi

