#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash
checkContainerStatusWithWait()
{
	state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "getCtrStateWithName" $1 $2 $3 $4)
	echo "current state of the container is $state"
	if  [[ $state == Error* ]]  ; then
		echo "Error Occured in state retrieval - Quitting!"
		exit 1
	fi
	if  [[ $state == "404" ]]  ; then
		echo "Container is not available - Quitting!"
		exit
	fi
	
	if [[ "$5" == "ipAction" ]] ; then
		echo "state just below the ip action check - $state"
		exitVal=1
		while [ $exitVal == 1 ]
		do
	        state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "getCtrStateWithName" $1 $2 $3 $4)
	        echo "Waiting for container to be up before IP assignment - current state of the container is $state"
			if [[ "$state" == "Running" ]]; then
				echo "state is $state - will exit"
				exitVal=0
			fi		
			if  [[ $state == "NotAvailable" ]]  ; then
				echo "Container is not available - Quitting!"
				exit 1
			fi		
			# Allow to container group to come up with that state
	        sleep 40s
		done
	fi
	
	if [[ "$5" == "stopAction" ]] ; then
		exitVal=1
		while [ $exitVal == 1 ]
		do
	        state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "getCtrStateWithName" $1 $2 $3 $4)
	        echo "Waiting for the container to be stopped.  Current state of the container is $state"
			if [[ "$state" == "Stopped" || "$state" == "Crashed" || "$state" == "Shutdown" ]]; then
				exitVal=0
			fi	
			if  [[ $state == "NotAvailable" ]]  ; then
				echo "Container is not available - Quitting!"
			fi			
					
			# Allow to container group to come up with that state
	        sleep 40s
		done
	fi
	
	if [[ "$5" == "removeAction" ]] ; then
		exitVal=1
		while [ $exitVal == 1 ]
		do
	        state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "getCtrStateWithName" $1 $2 $3 $4)
	        echo "waiting for the container to be removed - current state of the container is $state"
	        if [[ "$state" == "Crashed" ]]; then
				ctrId=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'getCtrIdWithName' $1 $2 $3 $4)
				removalResponse=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'removeContainer' $1 $2 $3 $ctrId)
				if  [[ $removalResponse == Error* ]]  ; then
					echo "Error Occured in removal of container - Quitting!"
			 		exit 1
				elif [[ "$removalResponse" == "204" ]] ; then
					echo "Request for removal of container succeeded"
				fi
			fi	
			if  [[ $state == "NotAvailable" ]]  ; then
				echo "Container is not available - Quitting!"
				exitVal=0
			fi	
			# Allow to container group to come up with that state
	        sleep 40s
	
		done
	fi
}

getCtrState()
{
	echo "inputs to get container status is $1 $2 $3 $4"
	state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'getCtrStateWithName' $1 $2 $3 $4)
	echo "state in getCtrState is $state"
	if  [[ $state == Error* ]]  ; then
		echo "Error Occured in state retrieval - Quitting!"
		exit 1
	fi
}

getCtrGrpState()
{
	echo "inputs to get container group status is $1 $2 $3 $4"
	state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'getCtrGrpStateWithName' $1 $2 $3 $4)
	echo "state in getCtrState is $state"
	if  [[ $state == Error* ]]  ; then
		echo "Error Occured in state retrieval - Quitting!"
		exit 1
	fi
}

checkContainerGrpStatusWithWait()
{
	state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "getCtrGrpStateWithName" $1 $2 $3 $4)
	echo "state of the container group is $state"
	if  [[ $state == Error* ]]  ; then
		echo "Error Occured in state retrieval - Quitting!"
		exit 1
	fi
	if  [[ $state == "NotAvailable" ]]  ; then
		echo "Container is not available - Quitting!"
	fi
	
	if [[ "$5" == "removeAction" ]] ; then
		exitVal=1
		while [ $exitVal == 1 ]
		do
	        state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "getCtrGrpStateWithName" $1 $2 $3 $4)
	        echo "waiting to remove the container group - current state of the container group is $state"
			if [[ "$state" == 404* ]]; then
				exitVal=0
			fi	
			if [[ "$state" == "DELETE_FAILED" ]]; then
				echo "state is DELETE_FAILED.  Will issue the removal again"
				removalResponse=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'stopDeleteCtrGrp' $1 $2 $3 $4)
				echo "Removal response is $stopResult"
				if  [[ $stopResult == Error* ]]  ; then
					echo "Error Occured in container group stop  - Quitting!"
					exit 1
				elif [[ "$removalResponse" == "204" ]] ; then
					echo "Request for removal of container succeeded"
				fi
			fi			
			# Allow to container group to come up with that state
	        sleep 40s
	
		done
	fi
	
	if [[ "$5" == "createAction" ]] ; then
		exitVal=1
		while [ $exitVal == 1 ]
		do
	        state=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "getCtrGrpStateWithName" $1 $2 $3 $4)
			echo "waiting for the container group to be created completely - current state of the container group is $state"
			if [[ "$state" == "CREATE_COMPLETE" ]]; then
				echo "state is create complete.  Will break the state check"
				exitVal=0
			fi	
			# Allow to container group to come up with that state
	        sleep 40s
	
		done
	fi
}

# The volume name and the path in the container that the volume will be mounted
SYSVOL_NAME=sysvol
LIBERTYVOL_NAME=libertyvol
SYSVOL_PATH=/var/log/rsyslog
LIBERTYVOL_PATH=/opt/ibm/wlp/usr/servers/worklight/logs

createDataVolume()
{
	OIFS=$IFS;
	IFS=",";

	volumeList=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'listVolumes' $1 $2 $3)
	echo "volumeList in createdataVolumes is $volumeList"
	if  [[ $volumeList == Error* ]]  ; then
		echo "Error Occured in volume retrieval - Quitting!"
		exit 1
	fi
	
	volumeArray=($volumeList);
	for ((i=0; i<${#volumeArray[@]}; ++i)); do 
	     if [[ "${volumeArray[$i]}" = "$4" ]]; then
	    	echo "${volumeArray[$i]} exist"
	    	datavolumeexist="true"
	    fi
	done
	
	if [ "$datavolumeexist" != "true" ] ; then
		echo "volume $4 does not exist - so making a REST request"
  		createDataVolumeResp=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'createVolume' $1 $2 $3 $4)
		echo "createVolume result is $createDataVolumeResp"
		if  [[ $createDataVolumeResp == Error* ]]  ; then
			echo "Error Occured in volume creation - Quitting!"
			exit 1
		fi
	fi
	
	IFS=$OIFS;
}


createVolumes() 
{
	volumeList=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'listVolumes' $1 $2 $3)
	echo "volumeList in createVolumes is $volumeList"
	if  [[ $volumeList == Error* ]]  ; then
		echo "Error Occured in volume retrieval - Quitting!"
		exit 1
	fi

	OIFS=$IFS;
	IFS=",";
	
	volumeArray=($volumeList);
	for ((i=0; i<${#volumeArray[@]}; ++i)); do 
		if [[ "${volumeArray[$i]}" = "$SYSVOL_NAME" ]]; then
	    	echo "${volumeArray[$i]} exist"
	    	sysvolexist="true"
	    elif [[ "${volumeArray[$i]}" = "$LIBERTYVOL_NAME" ]]; then
	    	echo "${volumeArray[$i]} exist"
	    	libertyvolexist="true"
	    fi
	done
	
	if [ "$sysvolexist" != "true" ] ; then
		echo "$SYSVOL_NAME does not exist - so making a REST request" 
  		createVolumeResp=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'createVolume' $1 $2 $3 $SYSVOL_NAME)
		echo "createVolume result is $createVolumeResp"
		if  [[ $createVolumeResp == Error* ]]  ; then
			echo "Error Occured in volume creation - Quitting!"
			exit 1
		fi
	fi

	if [ "$libertyvolexist" != "true" ] ; then
		echo "$LIBERTYVOL_NAME does not exist - so making a REST request"
  		createVolumeResp=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'createVolume' $1 $2 $3 $LIBERTYVOL_NAME)
		echo "createVolume result is $createVolumeResp"
		if  [[ $createVolumeResp == Error* ]]  ; then
			echo "Error Occured in volume creation - Quitting!"
			exit 1
		fi
	fi
	
	IFS=$OIFS;
}

