#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash
set -e

source $PLUGIN_HOME/MFPContainerFiles/initDocker.sh

#main

BLUEMIX_API_URL=$1
BLUEMIX_USER=$2
BLUEMIX_PASSWORD=$3
BLUEMIX_ORG=$4
BLUEMIX_SPACE=$5
DB_TYPE=$6
DB_SRV_NAME=$7
DB_SRV_PLAN=${8}
APP_NAME=${9}
ADMIN_SCHEMA_NAME=${10}
MFPF_WORKING_DIR=${11}

echo "Arguments : "
echo "----------- "
echo 
echo "BLUEMIX_API_URL : " $BLUEMIX_API_URL
echo "BLUEMIX_USER : " $BLUEMIX_USER
echo "BLUEMIX_PASSWORD : " XXXXXXXX
echo "BLUEMIX_ORG : " $BLUEMIX_ORG
echo "BLUEMIX_SPACE : " $BLUEMIX_SPACE
echo "DB_TYPE : " $DB_TYPE
echo "DB_SRV_NAME : " $DB_SRV_NAME
echo "DB_SRV_PLAN : " $DB_SRV_PLAN
echo "APP_NAME : " $APP_NAME
echo "ADMIN_SCHEMA_NAME : " $ADMIN_SCHEMA_NAME
echo "WORKING_DIR : " $MFPF_WORKING_DIR
echo 

if [[ "$MFPF_WORKING_DIR" == */ ]]; 
	then 
		temp=$MFPF_WORKING_DIR	
  		WORKING_DIR="${temp%?}"
  	else
  		WORKING_DIR=$MFPF_WORKING_DIR
fi
  
echo "WORKING_DIR is $WORKING_DIR"

mfp container login -a $BLUEMIX_API_URL -u $BLUEMIX_USER -p $BLUEMIX_PASSWORD -o $BLUEMIX_ORG -s $BLUEMIX_SPACE

if [ -z "$ADMIN_SCHEMA_NAME" ]
then
	ADMIN_SCHEMA_NAME=WLADMIN
fi

echo "admin shema name is $ADMIN_SCHEMA_NAME"

if [ "$DB_SRV_PLAN" != "sqldb_free" ]
then
    echo "SCHEMA_NAME : " $SCHEMA_NAME
else
    ADMIN_SCHEMA_NAME="SQLDB_FREE" # Send SQLDB_FREE so that the bluemix app recognises the plan
fi


#create admin schema / runtime 
mfp container configdb -t $DB_TYPE -n $DB_SRV_NAME -p $DB_SRV_PLAN -a $APP_NAME -s $ADMIN_SCHEMA_NAME -f $WORKING_DIR/mfpf-server/usr/config

# counter is maintained because if the db plan is sqldb_free, then only one runtime has to be added to the db.
COUNTER=0

if [ ! -z $WORKING_DIR ] 
then
	echo "No of projects to be deployed are not empty"	
	
	#projectsNumber=$(find . -mindepth 1 -maxdepth 1 -type d | wc -l)
	cd $WORKING_DIR/mfpf-server/usr/projects
	projects=$(find . -mindepth 1 -maxdepth 1 -type d)
	echo "projects are $projects"
	for DIR in $projects
	do
		COUNTER=$(expr $COUNTER + 1)
		echo "COUNTER is $COUNTER"
		if [ "$DB_SRV_PLAN" != "sqldb_free" ]
		then
			echo "db service plan is not sqldb free"
			mfp container configdb -t $DB_TYPE -n $DB_SRV_NAME -p $DB_SRV_PLAN -a $APP_NAME -s ${DIR##*/} -r ${DIR##*/} -f $WORKING_DIR/mfpf-server/usr/config
		else
		
		    ##ADMIN_SCHEMA_NAME="SQLDB_FREE" # Send SQLDB_FREE so that the bluemix app recognises the plan
		    SCHEMA_NAME="SQLDB_FREE"
			echo "-----------------------------db service plan is sqldb free"
		    if [ $COUNTER -le 1 ]
		    then
		    	echo "counter is <= 1"
		    else 
		    	echo "counter else"
		    	DB_SRV_NAME=${DIR##*/}
		    fi
		    
		    echo "SCHEMA_NAME in dbconfiguration is $SCHEMA_NAME"
			echo "DB_SRV_NAME in dbconfiguration is $DB_SRV_NAME"
		    mfp container configdb -t $DB_TYPE -n $DB_SRV_NAME -p $DB_SRV_PLAN -a $APP_NAME -s $SCHEMA_NAME -r ${DIR##*/} -f $WORKING_DIR/mfpf-server/usr/config
		fi
		##mfp container configdb -t $DB_TYPE -n $DB_SRV_NAME -p $DB_SRV_PLAN -a $APP_NAME -s ${DIR##*/} -r ${DIR##*/} -f $WORKING_DIR/mfpf-server/usr/config
	done
	
else
	echo "No of projects to be deployed are empty"
		
fi ##end of the paramWORKING_DIR check for empty


