#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash
set -e
#set -x

#main

BLUEMIX_API_URL=$1
BLUEMIX_CCS_HOST=$2
BLUEMIX_USER=$3
BLUEMIX_PASSWORD=$4
BLUEMIX_ORG=$5
BLUEMIX_SPACE=$6
SERVER_IMAGE_TAG=$7
SERVER_CONTAINER_GROUP_NAME=$8
SERVER_CONTAINER_GROUP_HOST=$9
SERVER_CONTAINER_GROUP_DOMAIN=${10}
SERVER_CONTAINER_GROUP_MIN=${11}
SERVER_CONTAINER_GROUP_MAX=${12}
SERVER_CONTAINER_GROUP_DESIRED=${13}
APP_NAME=${14}
SERVER_MEM=${15}
TRACE_SPEC=${16}
MAX_LOG_FILES=${17}
MAX_LOG_FILE_SIZE=${18}
ENABLE_VOLUME=${19}
MFPF_PROPERTIES=${20}
MFPF_WORKING_DIR=${21}


echo "Arguments : "
echo "----------- "
echo 
echo "BLUEMIX_API_URL : " $BLUEMIX_API_URL
echo "BLUEMIX_CCS_HOST : " $BLUEMIX_CCS_HOST
echo "BLUEMIX_USER : " $BLUEMIX_USER
echo "BLUEMIX_PASSWORD : " XXXXXXXX
echo "BLUEMIX_ORG : " $BLUEMIX_ORG
echo "BLUEMIX_SPACE : " $BLUEMIX_SPACE
echo "SERVER_IMAGE_TAG : " $SERVER_IMAGE_TAG
echo "SERVER_CONTAINER_GROUP_NAME : " $SERVER_CONTAINER_GROUP_NAME
echo "SERVER_CONTAINER_GROUP_HOST : " $SERVER_CONTAINER_GROUP_HOST
echo "SERVER_CONTAINER_GROUP_DOMAIN : " $SERVER_CONTAINER_GROUP_DOMAIN
echo "SERVER_CONTAINER_GROUP_MIN : " $SERVER_CONTAINER_GROUP_MIN
echo "SERVER_CONTAINER_GROUP_MAX : " $SERVER_CONTAINER_GROUP_MAX
echo "SERVER_CONTAINER_GROUP_DESIRED : " $SERVER_CONTAINER_GROUP_DESIRED
echo "APP_NAME : " $APP_NAME
echo "SERVER_MEM : " $SERVER_MEM
echo "TRACE_SPEC : " $TRACE_SPEC
echo "MAX_LOG_FILES : " $MAX_LOG_FILES
echo "MAX_LOG_FILE_SIZE : " $MAX_LOG_FILE_SIZE
echo "ENABLE_VOLUME : " $ENABLE_VOLUME
echo "ENVIRONMENT_PROPERTIES : " $MFPF_PROPERTIES
echo "WORKING_DIR : " $MFPF_WORKING_DIR
echo


if [[ "$MFPF_WORKING_DIR" == */ ]]; 
	then 
		temp=$MFPF_WORKING_DIR	
  		WORKING_DIR="${temp%?}"
  	else
  		WORKING_DIR=$MFPF_WORKING_DIR
fi
  
echo "working dir is $WORKING_DIR"

source $PLUGIN_HOME/MFPContainerFiles/initenv.sh
source $PLUGIN_HOME/MFPContainerFiles/ice_common_commands.sh
source $WORKING_DIR/mfpf-server/usr/env/server.env

echo "This assumes the group doesn't exist already.  Please make sure to add the removeContainerGroup step if required."


echo "Creating a new container"

#arg 1 - bluemix url
#arg 2 - accesstoken
#arg 3 - space guid
#arg 4 - SERVER_IMAGE_TAG
#arg 5 - SERVER_CONTAINER_GROUP_NAME
#arg 6 - memory
#arg 7 - SERVER_CONTAINER_GROUP_MIN
#arg 8 - SERVER_CONTAINER_GROUP_MAX
#arg 9 - SERVER_CONTAINER_GROUP_DESIRED
#arg 10 - volumes
#arg 11 - ports
#arg 12 - app Name
#arg 13 - environment properties
#arg 14 - command - which is null for mfp
#arg 15 - SERVER_CONTAINER_GROUP_HOST
#arg 16 - SERVER_CONTAINER_GROUP_DOMAIN

ports=""
args[0]="createContainerGrp"
args[1]=$BLUEMIX_CCS_HOST
args[2]=$access_token
args[3]=$spaceGUID
args[4]=$SERVER_IMAGE_TAG
args[5]=$SERVER_CONTAINER_GROUP_NAME
args[6]=$SERVER_MEM
args[7]=$SERVER_CONTAINER_GROUP_MIN
args[8]=$SERVER_CONTAINER_GROUP_MAX
args[9]=$SERVER_CONTAINER_GROUP_DESIRED


if [ -z "$TRACE_SPEC" ]
then
   TRACE_SPEC="*~info"
else
	TRACE_SPEC="$TRACE_SPEC"
fi

if [ -z "$MAX_LOG_FILES" ]
then
   MAX_LOG_FILES="5"
else
	MAX_LOG_FILES="$MAX_LOG_FILES"   
fi

if [ -z "$MAX_LOG_FILE_SIZE" ]
then
   MAX_LOG_FILE_SIZE="20"
else
	MAX_LOG_FILE_SIZE="$MAX_LOG_FILE_SIZE"   
fi

TRACE_SPEC=${TRACE_SPEC//"="/"~"}

environmentProps="MFPF_CLUSTER_MODE=Farm&TRACE_LEVEL=$TRACE_SPEC&MAX_LOG_FILES=$MAX_LOG_FILES&MAX_LOG_FILE_SIZE=$MAX_LOG_FILE_SIZE"
if [ ! -z "$MFPF_PROPERTIES" ]
then
	environmentProps="$environmentProps&mfpfproperties=$MFPF_PROPERTIES"
fi

if [ "$ENABLE_VOLUME" = "TRUE" ] || [ "$ENABLE_VOLUME" = "true" ]
then
    createVolumes "$BLUEMIX_CCS_HOST" $access_token $spaceGUID
  	volumes="$SYSVOL_NAME:$SYSVOL_PATH&$LIBERTYVOL_NAME:$LIBERTYVOL_PATH"
	environmentProps="$environmentProps&LOG_LOCATIONS=$SYSVOL_PATH/syslog,$LIBERTYVOL_PATH/messages.log,$LIBERTYVOL_PATH/console.log,$LIBERTYVOL_PATH/trace.log"
else
	volumes="null"
fi

args[10]="$volumes"

ports="$MFPF_SERVER_HTTPPORT"
args[11]="$ports"

if [ ! -z "$APP_NAME" ]
then 
   appName="$APP_NAME"
else
	appName="null"
fi
args[12]="$appName"

echo "environmentprops is $environmentProps"
args[13]="$environmentProps"
args[14]="null"
args[15]=$SERVER_CONTAINER_GROUP_HOST
args[16]="$SERVER_CONTAINER_GROUP_DOMAIN"

printf '%s\n' "${args[@]}"


createCtrResponse=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "createContainerGrp" ${args[1]} ${args[2]} ${args[3]} ${args[4]} ${args[5]} ${args[6]} ${args[7]} ${args[8]} ${args[9]} "$volumes" "$ports" ${args[12]} "$environmentProps" ${args[14]} ${args[15]} ${args[16]}) 
echo "Create container response for the server group is $createCtrResponse"
if  [[ $createCtrResponse == "" ]]  ; then
	echo "Error Occured in creation of container - Quitting!"
	exit 1
fi
if  [[ $createCtrResponse == Error* ]]  ; then
	echo "Error Occured in creation of container - Quitting!"
	exit 1
fi
echo "Create Server Successful"

checkContainerGrpStatusWithWait "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $SERVER_CONTAINER_GROUP_NAME "createAction"