#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash
#set -x

#main

BLUEMIX_API_URL=$1
BLUEMIX_CCS_HOST=$2
BLUEMIX_USER=$3
BLUEMIX_PASSWORD=$4
BLUEMIX_ORG=$5
BLUEMIX_SPACE=$6
SERVER_CONTAINER_NAME=$7
  		
echo "Arguments : "
echo "----------- "
echo 
echo "BLUEMIX_CCS_HOST : " $BLUEMIX_CCS_HOST
echo "BLUEMIX_USER : " $BLUEMIX_USER
echo "BLUEMIX_PASSWORD : " XXXXXXXX
echo "BLUEMIX_ORG : " $BLUEMIX_ORG
echo "BLUEMIX_SPACE : " $BLUEMIX_SPACE
echo "SERVER_CONTAINER_NAME : " $SERVER_CONTAINER_NAME
echo 

source $PLUGIN_HOME/MFPContainerFiles/initenv.sh
source $PLUGIN_HOME/MFPContainerFiles/ice_common_commands.sh
  
getCtrState "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $SERVER_CONTAINER_NAME
echo "Current state of the container to be removed is -  $state"

if [[ "$state" == "NotAvailable" ]]; then
	echo "Container does not exist already."
else
	echo "Container exist. Trying to delete it."
	ctrId=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'getCtrIdWithName' "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $SERVER_CONTAINER_NAME)
	echo "container id is $ctrId"
	if  [[ $ctrId == Error* ]]  ; then
		echo "Error Occured in container id retrieval  - Quitting!"
		exit 1
	fi
	
	removalResponse=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'removeContainer' "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $ctrId)
	echo "Removal response is $removalResponse"
	if  [[ $removalResponse == Error* ]]  ; then
			echo "Error Occured in removal of container - Quitting!"
			 exit 1
	elif [[ "$removalResponse" == "204" ]] ; then
		echo "Request for removal of container succeeded"
	fi
	echo "Removal issued.  Will wait for the container to be completely removed."
	checkContainerStatusWithWait "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $SERVER_CONTAINER_NAME "removeAction"
fi

