#   Licensed Materials - Property of IBM
#   5725-I43 (C) Copyright IBM Corp. 2011, 2015. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

#!/usr/bin/bash
#set -x
#main

BLUEMIX_API_URL=$1
BLUEMIX_CCS_HOST=$2
BLUEMIX_USER=$3
BLUEMIX_PASSWORD=$4
BLUEMIX_ORG=$5
BLUEMIX_SPACE=$6
ANALYTICS_IMAGE_TAG=$7
ANALYTICS_CONTAINER_NAME=$8
ANALYTICS_IP=$9
SSH_ENABLE=${10}
ENABLE_VOLUME=${11}
ENABLE_ANALYTICS_DATA_VOLUME=${12}
ANALYTICS_DATA_VOLUME_NAME=${13}
ANALYTICS_DATA_DIRECTORY=${14}
EXPOSE_HTTP=${15}
EXPOSE_HTTPS=${16}
SERVER_MEM=${17}
SSH_KEY=${18}
TRACE_SPEC=${19}
MAX_LOG_FILES=${20}
MAX_LOG_FILE_SIZE=${21}
MFPF_PROPERTIES=${22}
MFPF_WORKING_DIR=${23}



echo "Arguments : "
echo "----------- "
echo 
echo "BLUEMIX_API_URL : " $BLUEMIX_API_URL
echo "BLUEMIX_CCS_HOST : " $BLUEMIX_CCS_HOST
echo "BLUEMIX_USER : " $BLUEMIX_USER
echo "BLUEMIX_PASSWORD : " XXXXXXXX
echo "BLUEMIX_ORG : " $BLUEMIX_ORG
echo "BLUEMIX_SPACE : " $BLUEMIX_SPACE
echo "ANALYTICS_IMAGE_TAG : " $ANALYTICS_IMAGE_TAG
echo "ANALYTICS_CONTAINER_NAME : " $ANALYTICS_CONTAINER_NAME
echo "ANALYTICS_IP : " $ANALYTICS_IP
echo "SSH_ENABLE : " $SSH_ENABLE
echo "ENABLE_VOLUME : " $ENABLE_VOLUME
echo "ENABLE_ANALYTICS_DATA_VOLUME : " $ENABLE_ANALYTICS_DATA_VOLUME
echo "ANALYTICS_DATA_VOLUME_NAME : " $ANALYTICS_DATA_VOLUME_NAME
echo "ANALYTICS_DATA_DIRECTORY : " $ANALYTICS_DATA_DIRECTORY
echo "EXPOSE_HTTP : " $EXPOSE_HTTP
echo "EXPOSE_HTTPS : " $EXPOSE_HTTPS
echo "SERVER_MEM : " $SERVER_MEM
echo "SSH_KEY : " $SSH_KEY
echo "TRACE_SPEC : " $TRACE_SPEC
echo "MAX_LOG_FILES : " $MAX_LOG_FILES
echo "MAX_LOG_FILE_SIZE : " $MAX_LOG_FILE_SIZE
echo "ENVIRONMENT PROPERTIES : " $MFPF_PROPERTIES
echo "WORKING_DIR : " $MFPF_WORKING_DIR
echo

if [[ "$MFPF_WORKING_DIR" == */ ]]; 
	then 
		temp=$MFPF_WORKING_DIR
  		WORKING_DIR="${temp%?}"
  	else
  		WORKING_DIR=$MFPF_WORKING_DIR
fi

echo "working dir is $WORKING_DIR"

source $PLUGIN_HOME/MFPContainerFiles/initenv.sh
source $PLUGIN_HOME/MFPContainerFiles/ice_common_commands.sh
source $PLUGIN_HOME/MFPContainerFiles/mfpf-analytics/scripts/common.sh
source $WORKING_DIR/mfpf-analytics/usr/env/server.env

echo "This step assumes the container does not already exist.  You might want to add the Remove Container step if you want to automate it"
echo "Creating a new container"

#arg 1 - bluemix url
#arg 2 - accesstoken
#arg 3 - space guid
#arg 4 - ANALYTICS_IMAGE_TAG
#arg 5 - ANALYTICS_CONTAINER_NAME
#arg 6 - memroy
#arg 7 - environment properties
#arg 8 - command - which is null for mfp
#arg 9 - ssh key name 
#arg 10 - ports
#arg 11 - host config - empty for mfp
#arg 12 - app Name
#arg 13 - volumes
#arg 14 - number of cpus
#arg 15 - cpu set

args[0]="createContainer"
args[1]=$BLUEMIX_CCS_HOST
args[2]=$access_token
args[3]=$spaceGUID
args[4]=$ANALYTICS_IMAGE_TAG
args[5]=$ANALYTICS_CONTAINER_NAME
args[6]=$SERVER_MEM

if [ -z "$TRACE_SPEC" ]
then
TRACE_SPEC="*~info"
else
	TRACE_SPEC="$TRACE_SPEC"
fi

if [ -z "$MAX_LOG_FILES" ]
then
MAX_LOG_FILES="5"
else
MAX_LOG_FILES="$MAX_LOG_FILES"
fi

if [ -z "$MAX_LOG_FILE_SIZE" ]
then
MAX_LOG_FILE_SIZE="20"
else
MAX_LOG_FILE_SIZE="$MAX_LOG_FILE_SIZE"
fi


environmentProps="TRACE_LEVEL=$TRACE_SPEC&MAX_LOG_FILES=$MAX_LOG_FILES&MAX_LOG_FILE_SIZE=$MAX_LOG_FILE_SIZE"

if [ ! -z "$MFPF_PROPERTIES" ]
then
	environmentProps="$environmentProps&mfpfproperties=$MFPF_PROPERTIES"
fi

if [ "$ENABLE_VOLUME" = "true" ] || [ "$ENABLE_VOLUME" = "TRUE" ]
then
   createVolumes "$BLUEMIX_CCS_HOST" $access_token $spaceGUID
   volumes="$SYSVOL_NAME:$SYSVOL_PATH&$LIBERTYVOL_NAME:$LIBERTYVOL_PATH"
   environmentProps="$environmentProps&LOG_LOCATIONS=$SYSVOL_PATH/syslog,$LIBERTYVOL_PATH/messages.log,$LIBERTYVOL_PATH/console.log,$LIBERTYVOL_PATH/trace.log"
fi

if [ "$ENABLE_ANALYTICS_DATA_VOLUME" = "TRUE" ] || [ "$ENABLE_ANALYTICS_DATA_VOLUME" = "true" ]
then
   createDataVolume "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $ANALYTICS_DATA_VOLUME_NAME
   volumes="$volumes&$ANALYTICS_DATA_VOLUME_NAME:$ANALYTICS_DATA_DIRECTORY"
   environmentProps="$environmentProps&ANALYTICS_DATA_DIRECTORY=$ANALYTICS_DATA_DIRECTORY"
else
	environmentProps="$environmentProps&ANALYTICS_DATA_DIRECTORY=$ANALYTICS_DATA_DIRECTORY"
fi

echo "environmentprops is $environmentProps"
args[7]="$environmentProps"
args[8]="null"
if [ ! -z "$SSH_KEY" ] && ([ "$SSH_ENABLE" = "TRUE" ] || [ "$SSH_ENABLE" = "true" ])
then
	KeyName=$SSH_KEY
else
	KeyName="null"
fi
args[9]="$KeyName"


ports="9500"
if [ "$SSH_ENABLE" = "TRUE" ] || [ "$SSH_ENABLE" = "true" ]
then
   ports="$ports, 22"
fi


if [ "$EXPOSE_HTTP" = "TRUE" ] || [ "$EXPOSE_HTTP" = "true" ]
then
	ports="$ports, $ANALYTICS_HTTPPORT"
fi

if [ "$EXPOSE_HTTPS" = "TRUE" ] || [ "$EXPOSE_HTTPS" = "true" ]
then
   ports="$ports, $ANALYTICS_HTTPSPORT"
fi
echo "ports is $ports"
args[10]="$ports"
args[11]="null"
args[12]="null"
if [ -z "$volumes" ]; then
    volumes="null"
fi
echo "volumes is $volumes" 
args[13]="$volumes"
args[14]=0
args[15]="null"


#printf '%s\n' "${args[@]}"


createCtrResponse=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "createContainer" ${args[1]} ${args[2]} ${args[3]} ${args[4]} ${args[5]} ${args[6]} "$environmentProps" ${args[8]} "$KeyName" "$ports" ${args[11]} ${args[12]} "$volumes" ${args[14]} ${args[15]})
echo "Create container for analytics response is $createCtrResponse"
if  [[ $createCtrResponse == Error* ]]  ; then
	echo "Error Occured in creation of container - Quitting!"
	exit 1
fi
checkContainerStatusWithWait "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $ANALYTICS_CONTAINER_NAME "ipAction"

ctrId=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer 'getCtrIdWithName' "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $ANALYTICS_CONTAINER_NAME)
ipAssignResponse=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "assignIP" "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $ctrId $ANALYTICS_IP)
echo "Result of the IP assignment is $ipAssignResponse"
if  [[ $ipAssignResponse == Error* ]]  ; then
	echo "Error Occured in ip assignment to container - Quitting!"
	exit 1
fi