#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2015. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash
#set -e
#main

BLUEMIX_API_URL=$1
BLUEMIX_CCS_HOST=$2
BLUEMIX_USER=$3
BLUEMIX_PASSWORD=$4
BLUEMIX_ORG=$5
BLUEMIX_SPACE=$6
ANALYTICS_IMAGE_TAG=$7
ANALYTICS_CONTAINER_GROUP_NAME=$8
ANALYTICS_CONTAINER_GROUP_MIN=$9
ANALYTICS_CONTAINER_GROUP_MAX=${10}
ANALYTICS_CONTAINER_GROUP_DESIRED=${11}
ANALYTICS_CONTAINER_GROUP_HOST=${12}
ANALYTICS_CONTAINER_GROUP_DOMAIN=${13}
SERVER_MEM=${14}
TRACE_SPEC=${15}
MAX_LOG_FILES=${16}
MAX_LOG_FILE_SIZE=${17}
MFPF_PROPERTIES=${18}
ENABLE_VOLUME=${19}
ENABLE_ANALYTICS_DATA_VOLUME=${20}
ANALYTICS_DATA_VOLUME_NAME=${21}
ANALYTICS_DATA_DIRECTORY=${22}
WORKING_DIR=${23}

echo "Arguments : "
echo "----------- "
echo 
echo "BLUEMIX_API_URL : " $BLUEMIX_API_URL
echo "BLUEMIX_CCS_HOST : " $BLUEMIX_CCS_HOST
echo "BLUEMIX_USER : " $BLUEMIX_USER
echo "BLUEMIX_PASSWORD : " $BLUEMIX_PASSWORD
echo "BLUEMIX_ORG : " $BLUEMIX_ORG
echo "BLUEMIX_SPACE : " $BLUEMIX_SPACE
echo "ANALYTICS_IMAGE_TAG : " $ANALYTICS_IMAGE_TAG
echo "ANALYTICS_CONTAINER_GROUP_NAME : " $ANALYTICS_CONTAINER_GROUP_NAME
echo "ANALYTICS_CONTAINER_GROUP_MIN : " $ANALYTICS_CONTAINER_GROUP_MIN
echo "ANALYTICS_CONTAINER_GROUP_MAX : " $ANALYTICS_CONTAINER_GROUP_MAX
echo "ANALYTICS_CONTAINER_GROUP_DESIRED : " $ANALYTICS_CONTAINER_GROUP_DESIRED
echo "ANALYTICS_CONTAINER_GROUP_HOST : " $ANALYTICS_CONTAINER_GROUP_HOST
echo "ANALYTICS_CONTAINER_GROUP_DOMAIN : " $ANALYTICS_CONTAINER_GROUP_DOMAIN
echo "SERVER_MEM : " $SERVER_MEM
echo "TRACE_SPEC : " $TRACE_SPEC
echo "MAX_LOG_FILES : " $MAX_LOG_FILES
echo "MAX_LOG_FILE_SIZE : " $MAX_LOG_FILE_SIZE
echo "ENVIRONMENT PROPERTIES : " $MFPF_PROPERTIES
echo "ENABLE_VOLUME : " $ENABLE_VOLUME
echo "ENABLE_ANALYTICS_DATA_VOLUME : " $ENABLE_ANALYTICS_DATA_VOLUME
echo "ANALYTICS_DATA_VOLUME_NAME : " $ANALYTICS_DATA_VOLUME_NAME
echo "ANALYTICS_DATA_DIRECTORY : " $ANALYTICS_DATA_DIRECTORY
echo "WORKING_DIR : " $WORKING_DIR
echo

if [[ "$WORKING_DIR" == */ ]]; 
	then 
		temp=$WORKING_DIR
  		WORKING_DIR="${temp%?}"
fi

echo "working dir is $WORKING_DIR"


ANALYTICS_COMM_PORT=9600
ANALYTICS_DEBUG_PORT=9500

source $PLUGIN_HOME/MFPContainerFiles/initenv.sh
source $PLUGIN_HOME/MFPContainerFiles/ice_common_commands.sh
source $PLUGIN_HOME/MFPContainerFiles/mfpf-analytics/scripts/common.sh
source $WORKING_DIR/mfpf-analytics/usr/env/server.env


echo "This assumes the group doesn't exist already.  Please make sure to add the removeContainerGroup step if required."
echo "Creating a new container group"

#=====================================Preparing the array for the container group creation ======================================
#args 1 - bluemix url
#args 2 - accesstoken
#args 3 - space guid
#args 4 - ANALYTICS_IMAGE_TAG
#args 5 - ANALYTICS_CONTAINER_GROUP_NAME
#args 6 - SERVER_MEM
#args 7 - ANALYTICS_CONTAINER_GROUP_MIN
#args 8 - ANALYTICS_CONTAINER_GROUP_MAX
#args 9 - ANALYTICS_CONTAINER_GROUP_DESIRED
#args 10 - volumes
#args 11 - ports
#args 12 - app Name
#args 13 - environment properties
#args 14 - command - which is null for mfp
#args 15 - ANALYTICS_CONTAINER_GROUP_HOST
#args 16 - ANALYTICS_CONTAINER_GROUP_DOMAIN

args[0]="createContainerGrp"
args[1]=$BLUEMIX_CCS_HOST
args[2]=$access_token
args[3]=$spaceGUID
args[4]=$ANALYTICS_IMAGE_TAG
args[5]=$ANALYTICS_CONTAINER_GROUP_NAME
args[6]=$SERVER_MEM
args[7]=$ANALYTICS_CONTAINER_GROUP_MIN
args[8]=$ANALYTICS_CONTAINER_GROUP_MAX
args[9]=$ANALYTICS_CONTAINER_GROUP_DESIRED

environmentProps=null
volumes=null

if [ -z "$TRACE_SPEC" ]
then
   TRACE_SPEC="*~info"
else
	TRACE_SPEC="$TRACE_SPEC"
fi

if [ -z "$MAX_LOG_FILES" ]
then
   MAX_LOG_FILES="5"
else
	MAX_LOG_FILES="$MAX_LOG_FILES"
fi

if [ -z "$MAX_LOG_FILE_SIZE" ]
then
   MAX_LOG_FILE_SIZE="20"
else
	MAX_LOG_FILE_SIZE="$MAX_LOG_FILE_SIZE"   
fi

TRACE_SPEC=${TRACE_SPEC//"="/"~"}
environmentProps="ANALYTICS_TRACE_LEVEL=$TRACE_SPEC&ANALYTICS_MAX_LOG_FILES=$MAX_LOG_FILES&ANALYTICS_MAX_LOG_FILE_SIZE=$MAX_LOG_FILE_SIZE&ANALYTICS_multicast=true"  

if [ ! -z "$MFPF_PROPERTIES" ]
then
	environmentProps="$environmentProps&mfpfproperties==$MFPF_PROPERTIES"
fi

if [ "$ENABLE_VOLUME" = "TRUE" ] || [ "$ENABLE_VOLUME" = "true" ]
then
   createVolumes "$BLUEMIX_CCS_HOST" $access_token $spaceGUID
   volumes="$SYSVOL_NAME:$SYSVOL_PATH&$LIBERTYVOL_NAME:$LIBERTYVOL_PATH"
   environmentProps="${environmentProps}&LOG_LOCATIONS=$SYSVOL_PATH/syslog,$LIBERTYVOL_PATH/messages.log,$LIBERTYVOL_PATH/console.log,$LIBERTYVOL_PATH/trace.log"
fi


if [ "$ENABLE_ANALYTICS_DATA_VOLUME" = "TRUE" ] || [ "$ENABLE_ANALYTICS_DATA_VOLUME" = "true" ]
then
   createDataVolume "$BLUEMIX_CCS_HOST" $access_token $spaceGUID $ANALYTICS_DATA_VOLUME_NAME
   if [ -z "$volumes" ]; then
   		volumes="$ANALYTICS_DATA_VOLUME_NAME:$ANALYTICS_DATA_DIRECTORY"
   	else
   		volumes="${volumes}&$ANALYTICS_DATA_VOLUME_NAME:$ANALYTICS_DATA_DIRECTORY"
   	fi
   environmentProps="${environmentProps}&ANALYTICS_DATA_DIRECTORY=$ANALYTICS_DATA_DIRECTORY"
else 
   environmentProps="${environmentProps}&ANALYTICS_DATA_DIRECTORY=$ANALYTICS_DATA_DIRECTORY"  
fi

args[10]="$volumes"

echo "environmentprops is $environmentProps"

ports="$ANALYTICS_HTTPPORT"
args[11]="$ports"
args[12]="null"
args[13]="$environmentProps"
args[14]="null"
args[15]=${ANALYTICS_CONTAINER_GROUP_HOST}
args[16]=${ANALYTICS_CONTAINER_GROUP_DOMAIN}

printf '%s\n' "${args[@]}"

#=====================================End of Preparing the array for the container group creation ======================================


createAnalyticsCtrResponse=$(java com.ibm.mobilefirst.container.ManageMFPServerContainer "createContainerGrp" ${args[1]} ${args[2]} ${args[3]} ${args[4]} ${args[5]} ${args[6]} ${args[7]} ${args[8]} ${args[9]} "$volumes" "$ports" ${args[12]} "$environmentProps" ${args[14]} ${args[15]} ${args[16]}) 
echo "Create analytics container group response is $createAnalyticsCtrResponse"
if  [[ $createAnalyticsCtrResponse == "" ]]  ; then
	echo "Error Occured in creation of analytics container group - Quitting!"
	exit 1
fi
if  [[ "${createAnalyticsCtrResponse}" == Error* ]]  ; then
	echo "Error Occured in creation of analytics container group - Quitting!"
	exit 1
fi
echo "Create Analytics Server Group Successful"

checkContainerGrpStatusWithWait "${BLUEMIX_CCS_HOST}" $access_token $spaceGUID $ANALYTICS_CONTAINER_GROUP_NAME "createAction"

echo "End of the script"
