#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash
	

repackageWarFile(){
	
   binDir=${1%/*}
   projectDir=${binDir%/*}
   mkdir -p $projectDir/tmp
   cd $projectDir/tmp
   jar -xf $1
   rm $1
   if [ -d "$projectDir/server/conf" ] && [ "$(ls -A $projectDir/server/conf)" ]
   then
      cp $projectDir/server/conf/* $projectDir/tmp/WEB-INF/classes/conf/
   fi
   if [ -d "$projectDir/server/lib" ] && [ "$(ls -A $projectDir/server/lib)" ]
   then
      cp $projectDir/server/lib/* $projectDir/tmp/WEB-INF/lib/
   fi   
   jar -cf $1 *
   cd $projectDir
   rm -rf $projectDir/tmp
}

copyProjects(){
   IFS=","
   for v in $PROJECT_LOC
   do
      projName=${v##*"/"}
      if [ -d "$v" ] && [ -e "$v/bin/$projName.war" ]
         then
         mkdir -p  $WORKING_DIR/mfpf-server/usr/projects/$projName/bin
         cp -f $v/bin/$projName.war $WORKING_DIR/mfpf-server/usr/projects/$projName/bin
         adapter_files=$(find $v/bin/ -maxdepth 1 -name "*.adapter")
         if [ ! -z $adapter_files ]
         then
            echo "copying adapters " $adapter_files
            cp -f $v/bin/*.adapter $WORKING_DIR/mfpf-server/usr/projects/$projName/bin/
         fi
         
         wlapp_files=$(find $v/bin/ -maxdepth 1 -name "*.wlapp")
         if [ ! -z $wlapp_files ]
         then
            echo "copying applications " $wlapp_files
            cp -f $v/bin/*.wlapp $WORKING_DIR/mfpf-server/usr/projects/$projName/bin/
         fi
      else
         echo "$v is not a valid project path or it does not contain a runtime .war file in the $v/bin/ directory. Checking for .war files in the $v directory. Each .war file will be considered to represent a runtime"
         war_files=$(find $v/ -maxdepth 1 -name "*.war")
         if [ ! -z $war_files ]
         then
            for f in $v/*.war
            do
               projName=${f##*"/"}
               projName=${projName::$((${#projName}-4))}
               mkdir -p  $WORKING_DIR/mfpf-server/usr/projects/$projName/bin
               cp -f $f $WORKING_DIR/mfpf-server/usr/projects/$projName/bin/
            done
         else
            echo "Directory $v does not contain any runtime .war file."
            exit 1
         fi
      fi
   done
}

buildProjects()
{
   for dir in $WORKING_DIR/mfpf-server/usr/projects/*; do 
   	  projectDir=$dir
      projectName=${dir##*/}
      for file in $projectDir/bin/*; do
         if [[ ${file##*.} == war ]]
            then   
               warFilePath=$file
               relativeWarPath="usr/projects/$projectName/bin/${projectName}.war"
               #repackageWarFile $warFilePath
               cd $WORKING_DIR/mfpf-server/scripts
               # Update the Dockerfile with the war location
               appPath=/opt/ibm/wlp/usr/servers/worklight/apps/
               copyStr="COPY $relativeWarPath $appPath"
               RET_VAL=`grep -q "COPY $relativeWarPath $appPath" ../Dockerfile ; echo $?`
               #RET_VAL=$(grep -q $copyStr $WORKING_DIR/mfpf-server/Dockerfile; echo $?)
               echo "ret val is $RET_VAL"
               if [ ! $RET_VAL -eq 0 ]
               then
                  echo $copyStr >> $WORKING_DIR/mfpf-server/Dockerfile
               fi               
               break
         fi
      done
   done
}

migrateProjects()
{
   #### Migrate the project WAR files
   # check if user has overridden JAVA_HOME . else set to standard location
   if [ -z "$JAVA_HOME" ]
   then
      # export JAVA_HOME = "/usr/java"
      echo "JAVA_HOME not set. Please set JAVA_HOME for MFP migration to continue"
      exit 1
   else
      echo "JAVA_HOME:" $JAVA_HOME
   fi
   for d in $WORKING_DIR/mfpf-server/usr/projects/*
   do
       if [[ -d $d ]]; then
       	echo "in if of migrate"
         for war in $d/bin/*.war; do
            echo "******* Migrating:" $war "********"
            $WORKING_DIR/mfpf-libs/apache-ant-1.9.4/bin/ant -f $WORKING_DIR/mfpf-server/scripts/migrate.xml -Dwarfile=$war
         done
       fi
   done
}

clean_up() {
	# Perform clean up before exiting
	#cd "${absoluteScriptDir}"
        echo "in cleanup"
    if [ -d $WORKING_DIR/mfpf-server/dependencies ]
    then
        mv $WORKING_DIR/mfpf-server/dependencies $WORKING_DIR/dependencies
    fi
    if [ -d $WORKING_DIR/mfpf-server/mfpf-libs ]
    then
        mv $WORKING_DIR/mfpf-server/mfpf-libs $WORKING_DIR/mfpf-libs
    fi
    #currentDir=$(pwd`
    for dir in $WORKING_DIR/mfpf-server/usr/projects/*; do
    	projectDir=$dir
    	projectName=${dir##*/}
    	echo "project dir is $projectDir & project name is $projectName"
    	for file in $projectDir/bin/*; do
    		if [[ ${file##*.} == war ]]
    		then
    			if [[ -d ${projectDir}/tmp  && ! -z ${projectDir} ]]
    			then
    				echo "removal required"
    				rm -rf ${projectDir}/tmp
    			fi
    		    break
    		fi
    	done
    done
}
	