#   Licensed Materials - Property of IBM 
#   5725-I43 (C) Copyright IBM Corp. 2011, 2015. All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication or
#   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  
   
#!/usr/bin/bash
source $PLUGIN_HOME/MFPContainerFiles/initDocker.sh

#main

BLUEMIX_API_URL=$1
BLUEMIX_USER=$2
BLUEMIX_PASSWORD=$3
BLUEMIX_ORG=$4
BLUEMIX_SPACE=$5
RUNTIME_NAME=$6
SERVER_IP=$7
SERVER_PORT=$8
LIBERTY_ADMIN_USERNAME=$9
LIBERTY_ADMIN_PASSWORD=${10}
MFPF_ADMIN_USERNAME=${11}
MFPF_ADMIN_PASSWORD=${12}
DELETE_RUNTIME_DATA=${13}

if [ -z ${14} ] 
then
	MFPF_ADMIN_ROOT="worklightadmin"
else
	MFPF_ADMIN_ROOT=${14}
fi
APP_NAME=${15}
DB_SRV_NAME=${16}
SCHEMA_NAME=${17}
CERT_PATH=${18}
MFPF_WORKING_DIR=${19}

echo "Arguments : "
echo "----------- "
echo 
echo "BLUEMIX_API_URL : " $BLUEMIX_API_URL
echo "BLUEMIX_USER : " $BLUEMIX_USER
echo "BLUEMIX_PASSWORD : " XXXXXXXX
echo "BLUEMIX_ORG : " $BLUEMIX_ORG
echo "BLUEMIX_SPACE : " $BLUEMIX_SPACE
echo "RUNTIME_NAME : " $RUNTIME_NAME
echo "SERVER CONTAINER IP : " $SERVER_IP
echo "SERVER CONTAINER PORT (HTTPS) : " $SERVER_PORT
echo "LIBERTY ADMIN USER NAME : " $LIBERTY_ADMIN_USERNAME
echo "LIBERTY ADMIN PASSWORD : $LIBERTY_ADMIN_PASSWORD " 
echo "SERVER ADMIN USER NAME : " $MFPF_ADMIN_USERNAME
echo "SERVER ADMIN PASSWORD : XXXXXXXX "
echo "DELETE_RUNTIME_DATA : " $DELETE_RUNTIME_DATA
echo "DELETE_RUNTIME_PROJECT : " $DELETE_RUNTIME_PROJECT
echo "SERVER_ADMIN_ROOT : " $MFPF_ADMIN_ROOT

if [ "$DELETE_RUNTIME_DATA" = "TRUE" ] || [ "$DELETE_RUNTIME_DATA" = "true" ] 
then
   echo "APP_NAME : " $APP_NAME
   echo "DB_SRV_NAME : " $DB_SRV_NAME
   echo "SCHEMA_NAME : " $SCHEMA_NAME
fi
echo "CERT_PATH : " $CERT_PATH
echo "WORKING_DIR : " $MFPF_WORKING_DIR
echo 

if [[ "$MFPF_WORKING_DIR" == */ ]]; 
	then 
		temp=$MFPF_WORKING_DIR	
  		WORKING_DIR="${temp%?}"
  	else
  		WORKING_DIR=$MFPF_WORKING_DIR
fi

mfp container login -a $BLUEMIX_API_URL -u $BLUEMIX_USER -p $BLUEMIX_PASSWORD -o $BLUEMIX_ORG -s $BLUEMIX_SPACE

echo "Warning! Ensure that the $RUNTIME_NAME project is deleted manually from the usr/projects folder." 

echo "Deleting the configuration files of the $RUNTIME_NAME project..."
rm -f $WORKING_DIR/mfpf-server/usr/config/${RUNTIME_NAME}.xml

appPath=/opt/ibm/wlp/usr/servers/worklight/apps/
relativeWarPath="usr/projects/$RUNTIME_NAME/bin/${RUNTIME_NAME}.war"

line=$(grep -n "COPY $relativeWarPath $appPath" $WORKING_DIR/mfpf-server/Dockerfile | cut -d : -f 1 )
echo "line is $line"
if [ ! -z $line ] 
then     
	cd $WORKING_DIR/mfpf-server
	if [[ $platform == 'linux' ]]; then
		sed -i "$line d" Dockerfile
	else
		sed -i .bk "$line d" Dockerfile
   		rm -rf *.bk
	fi
	echo "Removed project references from the Dockerfile."
	
fi            

if [ "${DELETE_RUNTIME_DATA}" = "TRUE" ] || [ "${DELETE_RUNTIME_DATA}" = "true" ]
then
	echo "Deleting the $RUNTIME_NAME project related data from the database" 
	mfp container delete -n $DB_SRV_NAME -a $APP_NAME -s $SCHEMA_NAME -d "worklight"
fi
set -e
echo "Stopping the $RUNTIME_NAME project on the container..."

if [ -z $CERT_PATH ]
then
	curl -k -s -u $MFPF_ADMIN_USERNAME:$MFPF_ADMIN_PASSWORD -H "Content-Type : application/json" -X POST https://$SERVER_IP:$SERVER_PORT/IBMJMXConnectorREST/mbeans/WebSphere:name=$RUNTIME_NAME,service=com.ibm.websphere.application.ApplicationMBean/operations/stop -d {}
	curl -k -s -u $LIBERTY_ADMIN_USERNAME:$LIBERTY_ADMIN_PASSWORD -X DELETE https://$SERVER_IP:$SERVER_PORT/$MFPF_ADMIN_ROOT/management-apis/1.0/runtimes/$RUNTIME_NAME/lock
	curl -k -s -u $LIBERTY_ADMIN_USERNAME:$LIBERTY_ADMIN_PASSWORD -X DELETE https://$SERVER_IP:$SERVER_PORT/$MFPF_ADMIN_ROOT/management-apis/1.0/runtimes/$RUNTIME_NAME
else
	curl --capath $CERT_PATH -s -u $MFPF_ADMIN_USERNAME:$MFPF_ADMIN_PASSWORD -H "Content-Type : application/json" -X POST https://$SERVER_IP:$SERVER_PORT/IBMJMXConnectorREST/mbeans/WebSphere:name=$RUNTIME_NAME,service=com.ibm.websphere.application.ApplicationMBean/operations/stop -d {}
	curl --capath $CERT_PATH -s -u $LIBERTY_ADMIN_USERNAME:$LIBERTY_ADMIN_PASSWORD -X DELETE https://$SERVER_IP:$SERVER_PORT/$MFPF_ADMIN_ROOT/management-apis/1.0/runtimes/$RUNTIME_NAME/lock
	curl --capath $CERT_PATH -s -u $LIBERTY_ADMIN_USERNAME:$LIBERTY_ADMIN_PASSWORD -X DELETE https://$SERVER_IP:$SERVER_PORT/$MFPF_ADMIN_ROOT/management-apis/1.0/runtimes/$RUNTIME_NAME
fi
set +e
echo "Operation is complete."
