import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def airTools = new AirPluginTool(args[0], args[1])
final def props = airTools.getStepProperties()

final def msiFile = props['msiFile']
final def options = props['uninstallOptions']

final def cmdHelper = new CommandHelper(new File('.').canonicalFile)

def args = []
if (options && options.trim().length() > 0) {
    options.split('[\r\n]').each {
        if (it && it.trim().length() > 0) {
            args << it.trim()
        }
    }
}

def logFile = File.createTempFile('msiexec-', '.tmp')

def cmdArgs = ['cmd', '/C', "start /wait msiexec /L* \"$logFile\" /q /x \"$msiFile\" ${args.join(" ")}"];

def hasErrors = false
try {
    cmdHelper.runCommand("Uninstalling Package", cmdArgs)
}
catch (Exception e) {
    println e.message
    hasErrors = true
}
finally {
    logFile.eachLine {
        println it
        def m = it =~ /(?i).*error status: (\d+)./
        if (m.matches() && m[0][1].toInteger() != 0)  {
            hasErrors = true
        }
    }
    logFile.delete()
}

if (hasErrors) System.exit 1
