/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final def airTools = new AirPluginTool(args[0], args[1])
final def props = airTools.getStepProperties()
final def workDir = new File('.')

final def msiFile = props['msiFile']
final def logging = props['logging']
final def saveLogFile =  Boolean.parseBoolean(props['saveLogFile'])
final def options = props['installOptions']
final def cmdHelper = new CommandHelper(workDir)

def args = []
if (options && options.trim().length() > 0) {
    options.split('[\r\n]').each {
        if (it && it.trim().length() > 0) {
            args << it.trim()
        }
    }
}

def logFile = File.createTempFile('msiexec-', '.tmp', workDir)
if (saveLogFile) {
    airTools.setOutputProperty("logFile", logFile.getCanonicalPath());
} else {
    logFile.deleteOnExit()
}

def cmdArgs = ['cmd', '/C', "start /wait msiexec ${logging} \"${logFile.getCanonicalPath()}\" /q /I \"${msiFile}\" ${args.join(" ")}"]

def hasErrors = false
try {
    cmdHelper.runCommand("Installing Package", cmdArgs)
}
catch (Exception e) {
    println e.message
    hasErrors = true
}
finally {
    logFile.eachLine {
        println it
        def m = it =~ /(?i).*error status: (\d+)./
        if (m.matches() && m[0][1].toInteger() != 0)  {
            hasErrors = true
        }
    }
    airTools.storeOutputProperties();
}

if (hasErrors){
    println "[Error] The msiexec install command failed. View the above logs for details."
    System.exit(1)
}
