/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenClient {
    final String repo;
    final String proxyHost;
    final Integer proxyPort;
    final String proxyUsername;
    final String proxyPassword;
    final String user;
    final String password;
    final String groupId;
    final String artifactId;
    final String qualifier;
    final XPath xpath;
    private Map<String, File> tempDirs = new HashMap<String, File>();

    public MavenClient(String repo, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, String user, String password, String groupId, String artifactId, String qualifier) throws IOException {
        if (repo.endsWith("/")) {
            repo = repo.substring(0, repo.length() - 1);
        }
        this.repo = repo;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.user = user;
        this.password = password;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.qualifier = qualifier;
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMostRecentSnapshotVersion(String mavenVersion) throws IOException {
        String result;
        block10: {
            result = null;
            String url = this.getSnapshotMavenMetadataXmlPath(mavenVersion);
            HttpClient client = this.getHttpClient();
            try {
                HttpGet method = new HttpGet(url);
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    InputStream bodyStream = response.getEntity().getContent();
                    try {
                        InputSource bodySource = new InputSource(bodyStream);
                        try {
                            result = mavenVersion.replace("SNAPSHOT", this.getLatestSnapshotSuffix(bodySource));
                            break block10;
                        }
                        catch (XPathExpressionException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                        catch (SAXException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                    }
                    finally {
                        bodyStream.close();
                    }
                }
                System.out.println("[Error] Got non ok response from maven server : " + status + " at url " + url);
                throw new FileNotFoundException(url);
            }
            finally {
                this.closeClient(client);
            }
        }
        return result;
    }

    public boolean containsRevision(String revision) throws IOException {
        List<String> versionList = this.getVersionList();
        boolean result = versionList.contains(revision);
        if (!result) {
            System.out.println("[Info] Could not find specific revision, '" + revision + "' on " + this.getMavenMetadataXmlPath());
        }
        return result;
    }

    public List<String> getLatestVersions(String versionNamePattern) throws IOException {
        ArrayList<String> result = new ArrayList();
        List<String> versionList = this.getVersionList();
        if (versionNamePattern == null || versionNamePattern.trim().isEmpty()) {
            versionNamePattern = ".*";
        }
        result = this.getMatchingVersionNames(versionList, versionNamePattern);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getVersionList() throws IOException {
        List<String> result;
        block10: {
            result = null;
            String url = this.getMavenMetadataXmlPath();
            HttpClient client = this.getHttpClient();
            try {
                HttpGet method = new HttpGet(url);
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    InputStream bodyStream = response.getEntity().getContent();
                    try {
                        InputSource bodySource = new InputSource(bodyStream);
                        try {
                            result = this.getNamesFromXml(bodySource);
                            break block10;
                        }
                        catch (XPathExpressionException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                        catch (SAXException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                    }
                    finally {
                        bodyStream.close();
                    }
                }
                System.out.println("[Error] Got non ok response from maven server : " + status + " at url " + url);
                throw new FileNotFoundException(url);
            }
            finally {
                this.closeClient(client);
            }
        }
        return result;
    }

    private List<String> getNamesFromXml(InputSource body) throws SAXException, IOException, XPathExpressionException {
        Document document;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
            document = documentBuilderFactory.newDocumentBuilder().parse(body);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        XPathExpression allVersionsExpression = this.getAllVersionsExpression();
        NodeList nodeList = (NodeList)allVersionsExpression.evaluate(document, XPathConstants.NODESET);
        ArrayList<String> versionList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String version = nodeList.item(i).getTextContent().trim();
            versionList.add(version);
        }
        Collections.reverse(versionList);
        return versionList;
    }

    private List<String> getMatchingVersionNames(List<String> versionList, String versionNamePattern) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, Integer> group2Version = new HashMap<String, Integer>();
        Pattern regex = Pattern.compile(versionNamePattern);
        for (String version : versionList) {
            Matcher matcher = regex.matcher(version);
            if (matcher.matches()) {
                String group = null;
                try {
                    group = matcher.group(1);
                }
                catch (Exception e) {
                    group = "default";
                }
                Integer groupCount = (Integer)group2Version.get(group);
                if (groupCount == null) {
                    groupCount = 0;
                    System.out.println("Found group, '" + group + "'");
                }
                result.add(version);
                groupCount = groupCount + 1;
                group2Version.put(group, groupCount);
                System.out.println("[Action] Adding version: '" + version + "' from group: '" + group + "' (" + groupCount + ")");
                continue;
            }
            System.out.println("[Info] Version '" + version + "' does not match pattern, '" + versionNamePattern);
        }
        return result;
    }

    private String getLatestSnapshotSuffix(InputSource body) throws IOException, XPathExpressionException, SAXException {
        XPathExpression lastBuildNumberExpression;
        Document document;
        String result = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
            document = documentBuilderFactory.newDocumentBuilder().parse(body);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        XPathExpression lastNExpression = this.getLastSnapshotDateExpression();
        NodeList list = (NodeList)lastNExpression.evaluate(document, XPathConstants.NODESET);
        if (list.getLength() > 0) {
            result = list.item(0).getTextContent().trim();
        }
        if ((list = (NodeList)(lastBuildNumberExpression = this.getLastSnapshotBuildNumberExpression()).evaluate(document, XPathConstants.NODESET)).getLength() > 0) {
            result = result != null ? result + "-" + list.item(0).getTextContent().trim() : list.item(0).getTextContent().trim();
        }
        return result;
    }

    public File downloadFiles(String version, String mavenDatedVersion, String[] extensions) throws IOException {
        int foundFiles = 0;
        System.out.println("");
        System.out.println("Searching for files with the following extensions: " + Arrays.toString(extensions));
        for (String ext : extensions) {
            String url = this.getFileUrl(version, mavenDatedVersion, ext);
            try {
                this.download(version, url);
                ++foundFiles;
            }
            catch (FileNotFoundException swallow) {
                if (!StringUtils.equals((CharSequence)version, (CharSequence)mavenDatedVersion)) {
                    System.out.println("[Info] Not found. Trying filename without build number or timestamp...");
                    url = this.getFileUrl(version, version, ext);
                    try {
                        this.download(version, url);
                        ++foundFiles;
                    }
                    catch (FileNotFoundException swallow2) {
                        System.out.println("[Info] No file found at " + url);
                    }
                    continue;
                }
                System.out.println("[Info] No file found at " + url);
            }
        }
        System.out.println("");
        if (foundFiles <= 0) {
            System.out.println("[Error] No files found with extensions " + Arrays.toString(extensions) + " at the '" + this.repo + "' repository");
            throw new FileNotFoundException();
        }
        System.out.println("[Info] Downloaded " + foundFiles + " file(s).");
        return this.getTempDir(version);
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(System.getProperty("user.dir"), UUID.randomUUID().toString());
            IO.mkdirs(result);
            this.tempDirs.put(version, result);
        }
        return result;
    }

    private String getFileName(String url) throws IOException {
        int index = url.lastIndexOf(47);
        if (index == -1) {
            throw new IOException("Invalid URL");
        }
        String result = url.substring(index + 1);
        if (result.length() == 0) {
            throw new IOException("Invalid URL");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String version, String url) throws IOException {
        block4: {
            HttpClient client = this.getHttpClient();
            try {
                HttpGet method = new HttpGet(url);
                System.out.println("[Action] Downloading file from " + url + "...");
                HttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    File file = new File(this.getTempDir(version), this.getFileName(url));
                    IO.copy(response.getEntity().getContent(), file);
                    System.out.println("[Info] Downloaded " + file.getAbsolutePath());
                    break block4;
                }
                System.out.println("[Error] Got non ok response from maven server : " + status + " at url " + url);
                throw new FileNotFoundException(url);
            }
            finally {
                this.closeClient(client);
            }
        }
    }

    private String getMavenMetadataXmlPath() {
        String groupId = this.groupId.replace('.', '/');
        return String.format("%s/%s/%s/maven-metadata.xml", this.repo, groupId, this.artifactId);
    }

    private String getSnapshotMavenMetadataXmlPath(String mavenVersion) {
        String groupId = this.groupId.replace('.', '/');
        return String.format("%s/%s/%s/%s/maven-metadata.xml", this.repo, groupId, this.artifactId, mavenVersion);
    }

    private String getFileUrl(String version, String mavenDatedVersion, String extension) {
        String groupId = this.groupId.replace('.', '/');
        String qualifier = this.qualifier;
        if (qualifier == null) {
            qualifier = "";
        }
        if (qualifier.length() > 0) {
            qualifier = "-" + qualifier;
        }
        return String.format("%s/%s/%s/%s/%s-%s%s.%s", this.repo, groupId, this.artifactId, version, this.artifactId, mavenDatedVersion, qualifier, extension);
    }

    private XPathExpression getAllVersionsExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile("/metadata/versioning/versions/version");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private XPathExpression getLastSnapshotDateExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile(String.format("/metadata/versioning/snapshot/timestamp", new Object[0]));
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private XPathExpression getLastSnapshotBuildNumberExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile(String.format("/metadata/versioning/snapshot/buildNumber", new Object[0]));
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private HttpClient getHttpClient() {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        if (!StringUtils.isEmpty((CharSequence)this.user)) {
            builder.setUsername(this.user);
            builder.setPassword(this.password);
            builder.setPreemptiveAuthentication(true);
        }
        if (!StringUtils.isEmpty((CharSequence)this.proxyHost)) {
            builder.setProxyHost(this.proxyHost);
            builder.setProxyPort(this.proxyPort.intValue());
            if (!StringUtils.isEmpty((CharSequence)this.proxyUsername)) {
                builder.setProxyUsername(this.proxyUsername);
                builder.setProxyPassword(this.proxyPassword);
            }
        }
        DefaultHttpClient result = builder.buildClient();
        return result;
    }

    public void closeClient(HttpClient client) {
        ClientConnectionManager connectionManager = client.getConnectionManager();
        connectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        connectionManager.shutdown();
    }
}

