/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.air.plugin.command.MavenClient;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int execute() {
        int result = 0;
        try {
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String componentName = this.inputProperties.getProperty("componentName");
            String repoUrl = this.inputProperties.getProperty("repoUrl");
            String proxyHost = this.inputProperties.getProperty("proxyHost");
            String proxyPortString = this.inputProperties.getProperty("proxyPort");
            String proxyUsername = this.inputProperties.getProperty("proxyUsername");
            String proxyPassword = this.inputProperties.getProperty("proxyPassword");
            String mvnUsername = this.inputProperties.getProperty("user");
            String mvnPassword = this.inputProperties.getProperty("password");
            String groupId = this.inputProperties.getProperty("groupId");
            String artifactId = this.inputProperties.getProperty("artifactId");
            String mavenQualifier = this.inputProperties.getProperty("qualifier");
            Integer copyCount = Integer.valueOf(this.inputProperties.getProperty("copyCount"));
            String versionPattern = this.inputProperties.getProperty("versionPattern");
            String revision = this.inputProperties.getProperty("version");
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            String fileExtensionsString = this.inputProperties.getProperty("extension");
            String[] fileExtensions = new String[]{};
            if (fileExtensionsString != null) {
                fileExtensions = fileExtensionsString.split(",");
                for (int i = 0; i < fileExtensions.length; ++i) {
                    fileExtensions[i] = fileExtensions[i].trim();
                }
            }
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            Integer proxyPort = null;
            if (!StringUtils.isEmpty((CharSequence)proxyPortString)) {
                proxyPort = Integer.parseInt(proxyPortString);
            }
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            VersionClient versionClient = new VersionClient(url, username, password);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            MavenClient mavenClient = new MavenClient(repoUrl, proxyHost, proxyPort, proxyUsername, proxyPassword, mvnUsername, mvnPassword, groupId, artifactId, mavenQualifier);
            if (revision != null && revision.trim().length() > 0) {
                if (!mavenClient.containsRevision(revision)) throw new PluginExecutionException(String.format("Maven does not contain the version %s", revision));
                this.integrate(mavenClient, componentClient, versionClient, componentName, fileExtensions, revision, isUseVFS, charset, extensions);
                if (result == 0) return result;
                throw new PluginExecutionException(String.format("Integration failure", new Object[0]));
            }
            List<String> versions = mavenClient.getLatestVersions(versionPattern);
            Collections.reverse(versions);
            if (copyCount != null && copyCount < versions.size()) {
                versions = versions.subList(versions.size() - copyCount, versions.size());
                System.out.println("[Action] Importing the latest " + copyCount.toString() + " version(s) from Maven: " + versions);
            }
            int versionImportCount = 0;
            for (String version : versions) {
                if (versionImportCount >= copyCount) {
                    System.out.println("[Info] Reached latest build count max for import.");
                    break;
                }
                try {
                    boolean integrationResult = this.integrate(mavenClient, componentClient, versionClient, componentName, fileExtensions, version, isUseVFS, charset, extensions);
                    if (!integrationResult) continue;
                    ++versionImportCount;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new PluginExecutionException(String.format("Integration failure", new Object[0]));
                }
            }
            if (versions.size() >= 1) return result;
            System.out.println("Did not find any versions in Maven.");
            return result;
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            e.printStackTrace();
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean integrate(MavenClient maven, ComponentClient componentClient, VersionClient versionClient, String componentName, String[] fileExtensions, String mavenVersion, boolean isUseVFS, Charset charset, String[] extensions) throws Exception {
        boolean result;
        File tempDir;
        block13: {
            tempDir = null;
            result = true;
            try {
                String mavenDatedVersion = mavenVersion;
                String[] includes = new String[]{"**/*"};
                String[] excludes = new String[]{};
                boolean preserveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                if (mavenDatedVersion.contains("SNAPSHOT")) {
                    mavenDatedVersion = maven.getMostRecentSnapshotVersion(mavenVersion);
                }
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                List archivedVersions = componentClient.getArchivedComponentVersions(componentName);
                versions.addAll(archivedVersions);
                boolean hasVersion = versions.contains(mavenDatedVersion);
                System.out.println("Version from maven: " + mavenDatedVersion);
                if (!hasVersion) {
                    if (isUseVFS) {
                        System.out.println(String.format("Creating new version: %s and Uploading files to VFS", mavenDatedVersion));
                        tempDir = maven.downloadFiles(mavenVersion, mavenDatedVersion, fileExtensions);
                        Map<Object, Object> props = Collections.emptyMap();
                        if (!mavenDatedVersion.equals(mavenVersion)) {
                            props = Collections.singletonMap("baseVersion", mavenVersion);
                        }
                        String versionId = versionClient.createAndAddVersionFiles(componentName, mavenDatedVersion, "", tempDir, "", includes, excludes, preserveExecutePermissions, true, charset, extensions, props, Collections.emptyMap()).toString();
                        this.outputProperties.setProperty("VersionID", versionId);
                    } else {
                        System.out.println("Creating new version");
                        String versionId = versionClient.createVersion(componentName, mavenDatedVersion, " ").toString();
                        this.outputProperties.setProperty("VersionID", versionId);
                        System.out.println(String.format("Not uploading version %s to VFS because using VFS was not selected.", versionId));
                    }
                    break block13;
                }
                System.out.println(String.format("UCD already contains version %s. A duplicate will not be created.", mavenDatedVersion));
            }
            catch (Throwable throwable) {
                try {
                    if (tempDir != null && tempDir.exists()) {
                        IO.delete(tempDir);
                    }
                }
                catch (IOException e) {
                    System.err.println(String.format("[Error] Unable to delete download directory", e.getMessage()));
                }
                throw throwable;
            }
        }
        try {
            if (tempDir != null && tempDir.exists()) {
                IO.delete(tempDir);
            }
        }
        catch (IOException e) {
            System.err.println(String.format("[Error] Unable to delete download directory", e.getMessage()));
        }
        return result;
    }
}

