/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ds.client.AddVersionFilesCommand;
import com.urbancode.ds.client.DownloadVersionFilesCommand;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.UDRestClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionClient
extends UDRestClient {
    private static final Logger log = Logger.getLogger(ComponentClient.class);

    public VersionClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public VersionClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public VersionClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    public UUID createVersion(String component, String version, String description) throws IOException, JSONException {
        return this.createVersion(component, version, description, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createVersion(String component, String version, String description, boolean importing) throws IOException, JSONException {
        String sourceConfigExecutionRecordId;
        UUID result = null;
        String uri = this.url + "/cli/version/createVersion/?name=" + this.encodePath(version) + "&component=" + this.encodePath(component) + "&description=" + this.encodePath(description);
        if (this.isImportFinishedSupported()) {
            uri = uri + "&importing=" + String.valueOf(importing);
        }
        if ((sourceConfigExecutionRecordId = System.getenv("SOURCE_CONFIG_EXECUTION_RECORD")) != null && sourceConfigExecutionRecordId.length() > 0) {
            uri = uri + "&sourceConfigExecutionRecordId=" + this.encodePath(sourceConfigExecutionRecordId);
        }
        HttpPost method = new HttpPost(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            JSONObject jsonResult = new JSONObject(body);
            result = UUID.fromString((String)jsonResult.get("id"));
        }
        finally {
            response.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createZosVersion(String component, String version, String versionType, String packageManifestFile, String repositoryType) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/version/createZOSVersion/?" + "component=" + this.encodePath(component) + "&version=" + this.encodePath(version) + "&type=" + this.encodePath(versionType) + "&repositoryType=" + this.encodePath(repositoryType) + "&file=" + this.encodePath(packageManifestFile);
        HttpPost method = new HttpPost(uri);
        File manifestFile = new File(packageManifestFile);
        FileInputStream pkgManifestInputStream = new FileInputStream(manifestFile);
        BufferedHttpEntity entity = new BufferedHttpEntity(new InputStreamEntity((InputStream)pkgManifestInputStream, -1L));
        method.setEntity(entity);
        CloseableHttpResponse response = this.invokeMethod(method);
        try {
            String body = this.getBody(response);
            JSONObject jsonResult = new JSONObject(body);
            result = UUID.fromString((String)jsonResult.get("id"));
        }
        finally {
            response.close();
        }
        return result;
    }

    @Deprecated
    public void addVersionFiles(String component, String version, File base, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose) throws Exception {
        AddVersionFilesCommand command = new AddVersionFilesCommand(this.url.toString(), this.client, component, version, base, offset, includes, excludes, saveExecuteBits, verbose);
        command.execute();
    }

    public void addVersionFiles(String component, String version, File base, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose, Charset charset, String[] extensions) throws Exception {
        AddVersionFilesCommand command = new AddVersionFilesCommand(this.url.toString(), this.client, component, version, base, offset, includes, excludes, saveExecuteBits, verbose, charset, extensions);
        command.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(UUID versionId) throws IOException {
        String uri = this.url + "/rest/deploy/version/" + versionId.toString();
        HttpDelete method = new HttpDelete(uri);
        try {
            this.invokeMethod(method);
        }
        finally {
            this.releaseConnection(method);
        }
    }

    public UUID createAndAddVersionFiles(String component, String version, String description, File baseDir, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose, Charset charset, String[] extensions) throws Exception {
        return this.createAndAddVersionFiles(component, version, description, baseDir, offset, includes, excludes, saveExecuteBits, verbose, charset, extensions, Collections.<String, String>emptyMap(), Collections.<String, String>emptyMap());
    }

    public UUID createAndAddVersionFiles(String component, String version, String description, File baseDir, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose, Charset charset, String[] extensions, Map<String, String> versionProperties, Map<String, String> secureVersionProperties) throws Exception {
        UUID versionId = this.createVersion(component, version, description, true);
        try {
            this.addVersionFiles(component, version, baseDir, offset, includes, excludes, saveExecuteBits, verbose, charset, extensions);
            for (Map.Entry<String, String> ent : versionProperties.entrySet()) {
                this.setVersionProperty(version, component, ent.getKey(), ent.getValue(), false);
            }
            for (Map.Entry<String, String> ent : secureVersionProperties.entrySet()) {
                this.setVersionProperty(version, component, ent.getKey(), ent.getValue(), true);
            }
            this.markImportFinished(component, version);
        }
        catch (Exception e) {
            log.error("Error creating version" + e.getMessage());
            log.error("Cleaning up version " + versionId);
            this.deleteVersion(versionId);
            throw e;
        }
        return versionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markImportFinished(String component, String version) throws ClientProtocolException, IOException {
        if (!this.isImportFinishedSupported()) {
            return;
        }
        String uri = this.url + "/cli/version/finishedImporting/?" + "version=" + this.encodePath(version) + "&component=" + this.encodePath(component);
        HttpPost method = new HttpPost(uri);
        try {
            this.invokeMethod(method);
        }
        finally {
            this.releaseConnection(method);
        }
    }

    public JSONObject getVersion(String versionId) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/deploy/version/" + this.encodePath(versionId);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONObject(body);
        return result;
    }

    public UUID getVersionId(String component, String versionName) throws Exception {
        String uri = this.url + "/cli/version/getVersionId?component=" + this.encodePath(component) + "&version=" + this.encodePath(versionName);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        UUID versionId = UUID.fromString(body);
        return versionId;
    }

    public Map<String, String> getVersionProperties(String version, String component) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String uri = this.url + "/cli/version/versionProperties?version=" + this.encodePath(version);
        if (component != null) {
            uri = uri + "&component=" + this.encodePath(component);
        }
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray propsJSON = new JSONArray(body);
        for (int i = 0; i < propsJSON.length(); ++i) {
            JSONObject prop = propsJSON.getJSONObject(i);
            result.put(prop.getString("name"), prop.getString("value"));
        }
        return result;
    }

    public String setVersionProperty(String versionName, String componentName, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(versionName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/version/versionProperties";
        HttpPut method = null;
        if (this.isSecurePropTransfer()) {
            JSONObject entity = new JSONObject();
            try {
                entity.put("version", versionName).put("component", componentName).put("name", name).put("value", value).put("isSecure", isSecure);
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
            method = new HttpPut(uri);
            method.setEntity(new StringEntity(entity.toString()));
        } else {
            uri = uri + "?version=" + this.encodePath(versionName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
            if (!StringUtils.isEmpty(componentName)) {
                uri = uri + "&component=" + this.encodePath(componentName);
            }
            method = new HttpPut(uri);
        }
        CloseableHttpResponse response = this.invokeMethod(method);
        response.close();
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public void addVersionLink(String versionName, String componentName, String linkName, String link) throws IOException {
        if ("".equals(versionName) || "".equals(linkName) || "".equals(link)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/version/addLink?version=" + this.encodePath(versionName) + "&linkName=" + this.encodePath(linkName) + "&link=" + this.encodePath(link);
        if (!StringUtils.isEmpty(componentName)) {
            uri = uri + "&component=" + this.encodePath(componentName);
        }
        HttpPut method = new HttpPut(uri);
        CloseableHttpResponse response = this.invokeMethod(method);
        response.close();
    }

    public void downloadFiles(String component, String version, String download2Path, String singleFilePath) throws Exception {
        DownloadVersionFilesCommand dc = new DownloadVersionFilesCommand(this.url.toString(), this.client, component, version, download2Path, singleFilePath);
        dc.execute();
    }
}

