/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.ConcurrentHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NonPoolingExecutorService
extends AbstractExecutorService {
    private final AtomicInteger activeThreadCount = new AtomicInteger();
    private final Set<Thread> activeThreads = new ConcurrentHashSet<Thread>();
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final ThreadFactory threadFactory;
    private volatile boolean shutdown;
    private volatile boolean terminated;

    public NonPoolingExecutorService() {
        this(Executors.defaultThreadFactory());
    }

    public NonPoolingExecutorService(ThreadFactory threadFactory) {
        this.threadFactory = Check.nonNull(threadFactory, "threadFactory");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminationLatch.await(timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.activeThreadCount.get() == 0) {
            this.terminate();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        for (Thread thread : this.activeThreads) {
            thread.interrupt();
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(Runnable command) {
        if (this.shutdown) {
            throw new RejectedExecutionException("Pool is shut down.");
        }
        Thread thread = this.threadFactory.newThread(new ActiveRunnable(command));
        this.activeThreadCount.getAndIncrement();
        this.activeThreads.add(thread);
        thread.start();
    }

    private void completeThreadShutdown(Thread thread) {
        this.activeThreads.remove(thread);
        int count = this.activeThreadCount.decrementAndGet();
        if (this.shutdown && count == 0) {
            this.terminate();
        }
    }

    private void terminate() {
        this.terminated = true;
        this.terminationLatch.countDown();
    }

    private final class ActiveRunnable
    implements Runnable {
        private final Runnable delegate;

        ActiveRunnable(Runnable delegate) {
            this.delegate = Check.nonNull(delegate, "delegate");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!NonPoolingExecutorService.this.isShutdown()) {
                    this.delegate.run();
                }
            }
            finally {
                NonPoolingExecutorService.this.completeThreadShutdown(Thread.currentThread());
            }
        }
    }

    static final class InvokeAllCallable<V>
    implements Callable<V> {
        private final CountDownLatch latch;
        private final Callable<V> delegate;

        InvokeAllCallable(CountDownLatch latch, Callable<V> delegate) {
            this.latch = Check.nonNull(latch, "latch");
            this.delegate = Check.nonNull(delegate, "delegate");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() throws Exception {
            try {
                V v = this.delegate.call();
                return v;
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

