/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.air.plugin.command.MavenClient;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private static final Logger log = Logger.getLogger(ImportVersion.class);
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int execute() {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            String componentName = this.inputProperties.getProperty("componentName");
            String repoUrl = this.inputProperties.getProperty("repoUrl");
            String proxyHost = this.inputProperties.getProperty("proxyHost");
            String proxyPortString = this.inputProperties.getProperty("proxyPort");
            String proxyUsername = this.inputProperties.getProperty("proxyUsername");
            String proxyPassword = this.inputProperties.getProperty("proxyPassword");
            String mvnUsername = this.inputProperties.getProperty("user");
            String mvnPassword = this.inputProperties.getProperty("password");
            String groupId = this.inputProperties.getProperty("groupId");
            String artifactId = this.inputProperties.getProperty("artifactId");
            String mavenQualifier = this.inputProperties.getProperty("qualifier");
            String fileExtension = this.inputProperties.getProperty("extension");
            Integer latestBuildCount = Integer.valueOf(this.inputProperties.getProperty("copyCount"));
            String versionPattern = this.inputProperties.getProperty("versionPattern");
            String revision = this.inputProperties.getProperty("version");
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            Integer proxyPort = null;
            if (!StringUtils.isEmpty((CharSequence)proxyPortString)) {
                proxyPort = Integer.parseInt(proxyPortString);
            }
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            VersionClient versionClient = new VersionClient(url, username, password);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            MavenClient mavenClient = new MavenClient(repoUrl, proxyHost, proxyPort, proxyUsername, proxyPassword, mvnUsername, mvnPassword, groupId, artifactId, mavenQualifier);
            if (revision != null && revision.trim().length() > 0) {
                if (!mavenClient.containsRevision(revision)) throw new PluginExecutionException(String.format("Maven does not contain the version %s", revision));
                this.integrate(mavenClient, componentClient, versionClient, componentName, fileExtension, revision, isUseVFS, charset, extensions);
                return 0;
            } else {
                List<String> versions = mavenClient.getLatestVersions(latestBuildCount, versionPattern);
                for (String version : versions) {
                    this.integrate(mavenClient, componentClient, versionClient, componentName, fileExtension, version, isUseVFS, charset, extensions);
                }
                if (versions.size() >= 1) return 0;
                System.out.println("Did not find any versions in Maven.");
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public UUID integrate(MavenClient maven, ComponentClient componentClient, VersionClient versionClient, String componentName, String extension, String mavenVersion, boolean isUseVFS, Charset charset, String[] extensions) throws Exception {
        UUID result;
        block18: {
            File tempDir;
            block17: {
                tempDir = null;
                result = null;
                String mavenDatedVersion = mavenVersion;
                String[] includes = new String[]{"**/*"};
                String[] excludes = new String[]{};
                boolean preserveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                if (mavenDatedVersion.contains("SNAPSHOT")) {
                    mavenDatedVersion = maven.getMostRecentSnapshotVersion(mavenVersion);
                }
                List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                List archivedVersions = componentClient.getArchivedComponentVersions(componentName);
                versions.addAll(archivedVersions);
                boolean hasVersion = versions.contains(mavenDatedVersion);
                System.out.println("Version from maven: " + mavenDatedVersion);
                if (!hasVersion) {
                    if (isUseVFS) {
                        System.out.println(String.format("Creating new version: %s and Uploading files to VFS", mavenDatedVersion));
                        tempDir = maven.downloadFiles(mavenVersion, mavenDatedVersion, Collections.singletonList(extension));
                        String versionId = versionClient.createAndAddVersionFiles(componentName, mavenDatedVersion, "", tempDir, "", includes, excludes, preserveExecutePermissions, true, charset, extensions).toString();
                        this.outputProperties.setProperty("VersionID", versionId);
                    } else {
                        System.out.println("Creating new version");
                        String versionId = versionClient.createVersion(componentName, mavenDatedVersion, " ").toString();
                        this.outputProperties.setProperty("VersionID", versionId);
                        System.out.println(String.format("Not uploading version %s to VFS because using VFS was not selected.", versionId));
                    }
                    break block17;
                }
                System.out.println(String.format("UCD already contains version %s. A duplicate will not be created.", mavenDatedVersion));
            }
            try {
                if (tempDir != null && tempDir.exists()) {
                    IO.delete((File)tempDir);
                }
                break block18;
            }
            catch (IOException e) {
                System.err.println(String.format("Unable to delete download directory", e.getMessage()));
            }
            break block18;
            catch (Exception e) {
                try {
                    System.err.println(String.format("Error creating a new version: %s", e.getMessage()));
                    result = null;
                }
                catch (Throwable throwable) {
                    try {
                        if (tempDir != null && tempDir.exists()) {
                            IO.delete((File)tempDir);
                        }
                    }
                    catch (IOException e2) {
                        System.err.println(String.format("Unable to delete download directory", e2.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (tempDir != null && tempDir.exists()) {
                        IO.delete((File)tempDir);
                    }
                }
                catch (IOException e3) {
                    System.err.println(String.format("Unable to delete download directory", e3.getMessage()));
                }
            }
        }
        return result;
    }
}

