/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MavenClient {
    public static final String JAVAX_NET_SSL_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    final String repo;
    final String proxyHost;
    final Integer proxyPort;
    final String proxyUsername;
    final String proxyPassword;
    final String user;
    final String password;
    final String groupId;
    final String artifactId;
    final String qualifier;
    final boolean applyKeystore;
    final String keyStoreType;
    final String keyStoreFilePath;
    final String keyStorePassword;
    final KeyManagerFactoryDelegator keyManagerFactory;
    final StreamFactory streamFact;
    final XPath xpath;
    private Map<String, File> tempDirs = new HashMap<String, File>();

    public MavenClient(MavenClientConfig config) throws NoSuchAlgorithmException {
        this(config, new KeyManagerFactoryDelegator(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm())), FileInputStream::new);
    }

    protected MavenClient(MavenClientConfig config, KeyManagerFactoryDelegator kmf, StreamFactory streamFact) throws NoSuchAlgorithmException {
        String repo = config.getRepo();
        if (repo.endsWith("/")) {
            repo = repo.substring(0, repo.length() - 1);
        }
        this.repo = repo;
        this.proxyHost = config.getProxyHost();
        this.proxyPort = config.getProxyPort();
        this.proxyUsername = config.getProxyUsername();
        this.proxyPassword = config.getProxyPassword();
        this.user = config.getUser();
        this.password = config.getPassword();
        this.groupId = config.getGroupId();
        this.artifactId = config.getArtifactId();
        this.qualifier = config.getQualifier();
        this.applyKeystore = config.isApplyKeystore();
        this.keyManagerFactory = kmf;
        this.streamFact = streamFact;
        if (this.applyKeystore) {
            this.keyStoreType = System.getProperty(JAVAX_NET_SSL_KEY_STORE_TYPE);
            this.keyStoreFilePath = System.getProperty(JAVAX_NET_SSL_KEY_STORE);
            this.keyStorePassword = System.getProperty(JAVAX_NET_SSL_KEY_STORE_PASSWORD);
        } else {
            this.keyStorePassword = null;
            this.keyStoreFilePath = null;
            this.keyStoreType = null;
        }
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMostRecentSnapshotVersion(String mavenVersion) throws IOException {
        String result;
        block10: {
            result = null;
            String url = this.getSnapshotMavenMetadataXmlPath(mavenVersion);
            try (CloseableHttpClient client = this.getHttpClient();){
                HttpGet method = new HttpGet(url);
                CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    try (InputStream bodyStream = response.getEntity().getContent();){
                        InputSource bodySource = new InputSource(bodyStream);
                        try {
                            result = mavenVersion.replace("SNAPSHOT", this.getLatestSnapshotSuffix(bodySource));
                            break block10;
                        }
                        catch (XPathExpressionException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                        catch (SAXException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                    }
                }
                System.out.println("[Error] Got non ok response from maven server : " + status + " at url " + url);
                throw new FileNotFoundException(url);
            }
        }
        return result;
    }

    public boolean containsRevision(String revision) throws IOException {
        List<String> versionList = this.getVersionList();
        boolean result = versionList.contains(revision);
        if (!result) {
            System.out.println("[Info] Could not find specific revision, '" + revision + "' on " + this.getMavenMetadataXmlPath());
        }
        return result;
    }

    public List<String> getLatestVersions(String versionNamePattern) throws IOException {
        ArrayList<String> result = new ArrayList();
        List<String> versionList = this.getVersionList();
        if (versionNamePattern == null || versionNamePattern.trim().isEmpty()) {
            versionNamePattern = ".*";
        }
        result = this.getMatchingVersionNames(versionList, versionNamePattern);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getVersionList() throws IOException {
        List<String> result;
        block10: {
            result = null;
            String url = this.getMavenMetadataXmlPath();
            try (CloseableHttpClient client = this.getHttpClient();){
                HttpGet method = new HttpGet(url);
                CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    try (InputStream bodyStream = response.getEntity().getContent();){
                        InputSource bodySource = new InputSource(bodyStream);
                        try {
                            result = this.getNamesFromXml(bodySource);
                            break block10;
                        }
                        catch (XPathExpressionException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                        catch (SAXException e) {
                            throw (IOException)new IOException("Unable to parse " + url).initCause(e);
                        }
                    }
                }
                System.out.println("[Error] Got non ok response from maven server : " + status + " at url " + url);
                throw new FileNotFoundException(url);
            }
        }
        return result;
    }

    private List<String> getNamesFromXml(InputSource body) throws SAXException, IOException, XPathExpressionException {
        Document document;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
            document = documentBuilderFactory.newDocumentBuilder().parse(body);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        XPathExpression allVersionsExpression = this.getAllVersionsExpression();
        NodeList nodeList = (NodeList)allVersionsExpression.evaluate(document, XPathConstants.NODESET);
        ArrayList<String> versionList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String version = nodeList.item(i).getTextContent().trim();
            versionList.add(version);
        }
        Collections.reverse(versionList);
        return versionList;
    }

    private List<String> getMatchingVersionNames(List<String> versionList, String versionNamePattern) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, Integer> group2Version = new HashMap<String, Integer>();
        Pattern regex = Pattern.compile(versionNamePattern);
        for (String version : versionList) {
            Matcher matcher = regex.matcher(version);
            if (matcher.matches()) {
                String group = null;
                try {
                    group = matcher.group(1);
                }
                catch (Exception e) {
                    group = "default";
                }
                Integer groupCount = (Integer)group2Version.get(group);
                if (groupCount == null) {
                    groupCount = 0;
                    System.out.println("Found group, '" + group + "'");
                }
                result.add(version);
                groupCount = groupCount + 1;
                group2Version.put(group, groupCount);
                System.out.println("[Action] Adding version: '" + version + "' from group: '" + group + "' (" + groupCount + ")");
                continue;
            }
            System.out.println("[Info] Version '" + version + "' does not match pattern, '" + versionNamePattern);
        }
        return result;
    }

    private String getLatestSnapshotSuffix(InputSource body) throws IOException, XPathExpressionException, SAXException {
        XPathExpression lastBuildNumberExpression;
        Document document;
        String result = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
            document = documentBuilderFactory.newDocumentBuilder().parse(body);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        XPathExpression lastNExpression = this.getLastSnapshotDateExpression();
        NodeList list = (NodeList)lastNExpression.evaluate(document, XPathConstants.NODESET);
        if (list.getLength() > 0) {
            result = list.item(0).getTextContent().trim();
        }
        if ((list = (NodeList)(lastBuildNumberExpression = this.getLastSnapshotBuildNumberExpression()).evaluate(document, XPathConstants.NODESET)).getLength() > 0) {
            result = result != null ? result + "-" + list.item(0).getTextContent().trim() : list.item(0).getTextContent().trim();
        }
        return result;
    }

    public File downloadFiles(String version, String mavenDatedVersion, String[] extensions) throws IOException {
        int foundFiles = 0;
        System.out.println("");
        System.out.println("Searching for files with the following extensions: " + Arrays.toString(extensions));
        for (String ext : extensions) {
            String url = this.getFileUrl(version, mavenDatedVersion, ext);
            try {
                this.download(version, url);
                ++foundFiles;
            }
            catch (FileNotFoundException swallow) {
                if (!StringUtils.equals((CharSequence)version, (CharSequence)mavenDatedVersion)) {
                    System.out.println("[Info] Not found. Trying filename without build number or timestamp...");
                    url = this.getFileUrl(version, version, ext);
                    try {
                        this.download(version, url);
                        ++foundFiles;
                    }
                    catch (FileNotFoundException swallow2) {
                        System.out.println("[Info] No file found at " + url);
                    }
                    continue;
                }
                System.out.println("[Info] No file found at " + url);
            }
        }
        System.out.println("");
        if (foundFiles <= 0) {
            System.out.println("[Error] No files found with extensions " + Arrays.toString(extensions) + " at the '" + this.repo + "' repository");
            throw new FileNotFoundException();
        }
        System.out.println("[Info] Downloaded " + foundFiles + " file(s).");
        return this.getTempDir(version);
    }

    public String getOriginLink(String version) {
        String groupId = this.groupId.replace('.', '/');
        return String.format("%s/%s/%s/%s", this.repo, groupId, this.artifactId, version);
    }

    private File getTempDir(String version) throws IOException {
        File result = this.tempDirs.get(version);
        if (result == null) {
            result = new File(System.getProperty("user.dir"), UUID.randomUUID().toString());
            IO.mkdirs(result);
            this.tempDirs.put(version, result);
        }
        return result;
    }

    private String getFileName(String url) throws IOException {
        int index = url.lastIndexOf(47);
        if (index == -1) {
            throw new IOException("Invalid URL");
        }
        String result = url.substring(index + 1);
        if (result.length() == 0) {
            throw new IOException("Invalid URL");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String version, String url) throws IOException {
        block4: {
            try (CloseableHttpClient client = this.getHttpClient();){
                HttpGet method = new HttpGet(url);
                System.out.println("[Action] Downloading file from " + url + "...");
                CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    File file = new File(this.getTempDir(version), this.getFileName(url));
                    IO.copy(response.getEntity().getContent(), file);
                    System.out.println("[Info] Downloaded " + file.getAbsolutePath());
                    break block4;
                }
                System.out.println("[Error] Got non ok response from maven server : " + status + " at url " + url);
                throw new FileNotFoundException(url);
            }
        }
    }

    private String getMavenMetadataXmlPath() {
        String groupId = this.groupId.replace('.', '/');
        return String.format("%s/%s/%s/maven-metadata.xml", this.repo, groupId, this.artifactId);
    }

    private String getSnapshotMavenMetadataXmlPath(String mavenVersion) {
        return this.getOriginLink(mavenVersion) + "/maven-metadata.xml";
    }

    private String getFileUrl(String version, String mavenDatedVersion, String extension) {
        String qualifier = this.qualifier;
        if (qualifier == null) {
            qualifier = "";
        }
        if (qualifier.length() > 0) {
            qualifier = "-" + qualifier;
        }
        String origin = this.getOriginLink(version);
        return String.format("%s/%s-%s%s.%s", origin, this.artifactId, mavenDatedVersion, qualifier, extension);
    }

    private XPathExpression getAllVersionsExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile("/metadata/versioning/versions/version");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private XPathExpression getLastSnapshotDateExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile(String.format("/metadata/versioning/snapshot/timestamp", new Object[0]));
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private XPathExpression getLastSnapshotBuildNumberExpression() {
        XPathExpression result;
        try {
            result = this.xpath.compile(String.format("/metadata/versioning/snapshot/buildNumber", new Object[0]));
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private CloseableHttpClient getHttpClient() {
        return this.getHttpClient(new HttpClientBuilder());
    }

    protected CloseableHttpClient getHttpClient(HttpClientBuilder builder) {
        builder.setTimeoutMillis(60000);
        builder.setTrustAllCerts(true);
        if (!StringUtils.isEmpty((CharSequence)this.user)) {
            builder.setUsername(this.user);
            builder.setPassword(this.password);
            builder.setPreemptiveAuthentication(true);
        }
        if (!StringUtils.isEmpty((CharSequence)this.proxyHost)) {
            builder.setProxyHost(this.proxyHost);
            builder.setProxyPort(this.proxyPort.intValue());
            if (!StringUtils.isEmpty((CharSequence)this.proxyUsername)) {
                builder.setProxyUsername(this.proxyUsername);
                builder.setProxyPassword(this.proxyPassword);
            }
        }
        if (this.applyKeystore) {
            System.out.println("[Info] Adding keystore");
            try {
                if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.keyStoreFilePath, this.keyStoreType, this.keyStorePassword})) {
                    throw new IllegalArgumentException(String.format("The following java properties must be defined: %s, %s, %s", JAVAX_NET_SSL_KEY_STORE, JAVAX_NET_SSL_KEY_STORE_PASSWORD, JAVAX_NET_SSL_KEY_STORE_TYPE));
                }
                KeyStore ks = KeyStore.getInstance(this.keyStoreType);
                char[] ksPass = this.keyStorePassword.toCharArray();
                ks.load(this.streamFact.get(this.keyStoreFilePath), ksPass);
                this.keyManagerFactory.init(ks, ksPass);
                builder.setKeyManagers(this.keyManagerFactory.getKeyManagers());
            }
            catch (Exception e) {
                System.out.println("[Error] error applying Keystore");
                throw new RuntimeException(e);
            }
        }
        DefaultHttpClient result = builder.buildClient();
        return result;
    }

    static class MavenClientConfig {
        private String repo;
        private final String proxyHost;
        private final Integer proxyPort;
        private final String proxyUsername;
        private final String proxyPassword;
        private final String user;
        private final String password;
        private final String groupId;
        private final String artifactId;
        private final String qualifier;
        private final boolean applyKeystore;

        MavenClientConfig(String repo, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword, String user, String password, String groupId, String artifactId, String qualifier, boolean applyKeystore) {
            this.repo = repo;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUsername = proxyUsername;
            this.proxyPassword = proxyPassword;
            this.user = user;
            this.password = password;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.qualifier = qualifier;
            this.applyKeystore = applyKeystore;
        }

        public String getRepo() {
            return this.repo;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public String getProxyUsername() {
            return this.proxyUsername;
        }

        public String getProxyPassword() {
            return this.proxyPassword;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public boolean isApplyKeystore() {
            return this.applyKeystore;
        }
    }

    static class KeyManagerFactoryDelegator {
        private KeyManagerFactory keyManagerFactory;

        public KeyManagerFactoryDelegator(KeyManagerFactory keyManagerFactory) {
            this.keyManagerFactory = keyManagerFactory;
        }

        public void init(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            this.keyManagerFactory.init(ks, password);
        }

        public KeyManager[] getKeyManagers() {
            return this.keyManagerFactory.getKeyManagers();
        }
    }

    @FunctionalInterface
    static interface StreamFactory {
        public FileInputStream get(String var1) throws FileNotFoundException;
    }
}

